/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portlet.PortletPreferencesImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesLocalUtil {
    public static final String CACHE_NAME = PortletPreferencesLocalUtil.class.getName();
    private static PortalCache _cache = MultiVMPoolUtil.getCache((String)CACHE_NAME);

    protected static void clearPreferencesPool() {
        _cache.removeAll();
    }

    protected static void clearPreferencesPool(long ownerId, int ownerType) {
        String key = PortletPreferencesLocalUtil._encodeKey(ownerId, ownerType);
        _cache.remove(key);
    }

    protected static Map<String, PortletPreferencesImpl> getPreferencesPool(long ownerId, int ownerType) {
        String key = PortletPreferencesLocalUtil._encodeKey(ownerId, ownerType);
        ConcurrentHashMap preferencesPool = (ConcurrentHashMap)_cache.get(key);
        if (preferencesPool == null) {
            preferencesPool = new ConcurrentHashMap();
            _cache.put(key, preferencesPool);
        }
        return preferencesPool;
    }

    private static String _encodeKey(long ownerId, int ownerType) {
        StringBuilder sb = new StringBuilder();
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(ownerId);
        sb.append("#");
        sb.append(ownerType);
        return sb.toString();
    }
}

