/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.base.PortletServiceBaseImpl;
import java.util.List;

public class PortletServiceImpl
extends PortletServiceBaseImpl {
    public JSONArray getWARPortlets() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List portlets = this.portletLocalService.getPortlets();
        for (Portlet portlet : portlets) {
            PortletApp portletApp = portlet.getPortletApp();
            if (!portletApp.isWARFile()) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("portlet_name", portlet.getPortletName());
            jsonObject.put("servlet_context_name", portletApp.getServletContextName());
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.portletLocalService.updatePortlet(companyId, portletId, roles, active);
    }
}

