/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchReleaseException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.dao.shard.ShardUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Release;
import com.liferay.portal.service.base.ReleaseLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;

public class ReleaseLocalServiceImpl
extends ReleaseLocalServiceBaseImpl {
    private static final String _GET_BUILD_NUMBER = "select buildNumber from Release_ where releaseId = ?";
    private static final String _TEST_DATABASE_STRING_CASE_SENSITIVITY = "select count(*) from Release_ where releaseId = ? and testString = ?";
    private static Log _log = LogFactoryUtil.getLog(ReleaseLocalServiceImpl.class);

    public Release addRelease(String servletContextName, int buildNumber) throws SystemException {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date now = new Date();
        release.setCreateDate(now);
        release.setModifiedDate(now);
        release.setServletContextName(servletContextName);
        release.setBuildNumber(buildNumber);
        if (servletContextName.equals("portal")) {
            release.setTestString("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        this.releasePersistence.update((BaseModel)release, false);
        return release;
    }

    public void createTablesAndPopulate() throws SystemException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Create tables and populate with default data");
            }
            DB db = DBFactoryUtil.getDB();
            db.runSQLTemplate("portal-tables.sql", false);
            db.runSQLTemplate("portal-data-common.sql", false);
            db.runSQLTemplate("portal-data-counter.sql", false);
            if (!GetterUtil.getBoolean((String)PropsUtil.get("schema.run.minimal")) && !ShardUtil.isEnabled()) {
                db.runSQLTemplate("portal-data-sample.vm", false);
            }
            db.runSQLTemplate("portal-data-release.sql", false);
            db.runSQLTemplate("indexes.sql", false);
            db.runSQLTemplate("sequences.sql", false);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new SystemException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBuildNumberOrCreate() throws PortalException, SystemException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_BUILD_NUMBER);
            ps.setLong(1, 1L);
            rs = ps.executeQuery();
            if (rs.next()) {
                int buildNumber = rs.getInt("buildNumber");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Build number " + buildNumber));
                }
                this.testSupportsStringCaseSensitiveQuery();
                int n = buildNumber;
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return n;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e.getMessage());
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("schema.run.enabled"))) {
            this.releaseLocalService.createTablesAndPopulate();
            this.testSupportsStringCaseSensitiveQuery();
            Release release = this.getRelease("portal", ReleaseInfo.getBuildNumber());
            return release.getBuildNumber();
        }
        throw new NoSuchReleaseException("The database needs to be populated");
    }

    public Release getRelease(String servletContextName, int buildNumber) throws PortalException, SystemException {
        if (Validator.isNull((String)servletContextName)) {
            throw new IllegalArgumentException("Servlet context name cannot be null");
        }
        servletContextName = servletContextName.toLowerCase();
        Release release = null;
        release = servletContextName.equals("portal") ? this.releasePersistence.findByPrimaryKey(1L) : this.releasePersistence.findByServletContextName(servletContextName);
        return release;
    }

    public Release updateRelease(long releaseId, int buildNumber, Date buildDate, boolean verified) throws PortalException, SystemException {
        Release release = this.releasePersistence.findByPrimaryKey(releaseId);
        release.setModifiedDate(new Date());
        release.setBuildNumber(buildNumber);
        release.setBuildDate(buildDate);
        release.setVerified(verified);
        this.releasePersistence.update((BaseModel)release, false);
        return release;
    }

    protected void testSupportsStringCaseSensitiveQuery() throws SystemException {
        DB db = DBFactoryUtil.getDB();
        int count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        if (count == 0) {
            block9: {
                block8: {
                    try {
                        db.runSQL("alter table Release_ add testString VARCHAR(1024) null");
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) break block8;
                        _log.debug((Object)e.getMessage());
                    }
                }
                try {
                    db.runSQL("update Release_ set testString = 'You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.'");
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)e.getMessage());
                }
            }
            count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        if (count == 0) {
            throw new SystemException("Release_ table was not initialized properly");
        }
        count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.".toUpperCase());
        if (count == 0) {
            db.setSupportsStringCaseSensitiveQuery(true);
        } else {
            db.setSupportsStringCaseSensitiveQuery(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int testSupportsStringCaseSensitiveQuery(String testString) {
        int count = 0;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_TEST_DATABASE_STRING_CASE_SENSITIVITY);
            ps.setLong(1, 1L);
            ps.setString(2, testString);
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e.getMessage());
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
        return count;
    }
}

