/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchResourceActionException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.service.base.ResourceActionLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceActionLocalServiceImpl
extends ResourceActionLocalServiceBaseImpl {
    private static Map<String, ResourceAction> _resourceActions = new HashMap<String, ResourceAction>();

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceActions() throws SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        List resourceActions = this.resourceActionPersistence.findAll();
        for (ResourceAction resourceAction : resourceActions) {
            String key = this.encodeKey(resourceAction.getName(), resourceAction.getActionId());
            _resourceActions.put(key, resourceAction);
        }
    }

    public void checkResourceActions(String name, List<String> actionIds) throws SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        List resourceActions = this.resourceActionPersistence.findByName(name);
        resourceActions = ListUtil.copy((List)resourceActions);
        this.checkResourceActions(name, actionIds, resourceActions);
    }

    public ResourceAction getResourceAction(String name, String actionId) throws PortalException {
        String key = this.encodeKey(name, actionId);
        ResourceAction resourceAction = _resourceActions.get(key);
        if (resourceAction == null) {
            throw new NoSuchResourceActionException(key);
        }
        return resourceAction;
    }

    public List<ResourceAction> getResourceActions(String name) throws SystemException {
        return this.resourceActionPersistence.findByName(name);
    }

    protected void checkResourceActions(String name, List<String> actionIds, List<ResourceAction> resourceActions) throws SystemException {
        long lastBitwiseValue = 1L;
        if (!resourceActions.isEmpty()) {
            ResourceAction resourceAction = resourceActions.get(resourceActions.size() - 1);
            lastBitwiseValue = resourceAction.getBitwiseValue();
        }
        int lastBitwiseLogValue = MathUtil.base2Log((long)lastBitwiseValue);
        for (String actionId : actionIds) {
            String key = this.encodeKey(name, actionId);
            ResourceAction resourceAction = _resourceActions.get(key);
            if (resourceAction == null) {
                resourceAction = this.resourceActionPersistence.fetchByN_A(name, actionId);
            }
            if (resourceAction != null) continue;
            long bitwiseValue = 1L;
            if (!actionId.equals("VIEW")) {
                bitwiseValue = MathUtil.base2Pow((int)(++lastBitwiseLogValue));
            }
            long resourceActionId = this.counterLocalService.increment(ResourceAction.class.getName());
            resourceAction = this.resourceActionPersistence.create(resourceActionId);
            resourceAction.setName(name);
            resourceAction.setActionId(actionId);
            resourceAction.setBitwiseValue(bitwiseValue);
            this.resourceActionPersistence.update((BaseModel)resourceAction, false);
            _resourceActions.put(key, resourceAction);
        }
    }

    protected String encodeKey(String name, String actionId) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("#");
        sb.append(actionId);
        return sb.toString();
    }
}

