/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateUserGroupException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.PortalException;
import com.liferay.portal.RequiredUserGroupException;
import com.liferay.portal.SystemException;
import com.liferay.portal.UserGroupNameException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.UserGroupLocalServiceBaseImpl;
import com.liferay.portlet.enterpriseadmin.util.UserIndexer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupLocalServiceImpl
extends UserGroupLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(UserGroupLocalServiceImpl.class);

    public void addGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException, SystemException {
        this.groupPersistence.addUserGroups(groupId, userGroupIds);
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Role role = this.rolePersistence.findByC_N(group.getCompanyId(), "Community Member");
        for (long userGroupId : userGroupIds) {
            this.userGroupGroupRoleLocalService.addUserGroupGroupRoles(userGroupId, groupId, new long[]{role.getRoleId()});
        }
        PermissionCacheUtil.clearCache();
    }

    public UserGroup addUserGroup(long userId, long companyId, String name, String description) throws PortalException, SystemException {
        this.validate(0L, companyId, name);
        long userGroupId = this.counterLocalService.increment();
        UserGroup userGroup = this.userGroupPersistence.create(userGroupId);
        userGroup.setCompanyId(companyId);
        userGroup.setParentUserGroupId(0L);
        userGroup.setName(name);
        userGroup.setDescription(description);
        this.userGroupPersistence.update((BaseModel)userGroup, false);
        this.groupLocalService.addGroup(userId, UserGroup.class.getName(), userGroup.getUserGroupId(), String.valueOf(userGroupId), null, 0, null, true, null);
        this.resourceLocalService.addResources(companyId, 0L, userId, UserGroup.class.getName(), userGroup.getUserGroupId(), false, false, false);
        return userGroup;
    }

    public void clearUserUserGroups(long userId) throws SystemException {
        this.userPersistence.clearUserGroups(userId);
        PermissionCacheUtil.clearCache();
    }

    public void copyUserGroupLayouts(long userGroupId, long[] userIds) throws PortalException, SystemException {
        for (long userId : userIds) {
            if (this.userGroupPersistence.containsUser(userGroupId, userId)) continue;
            this.copyUserGroupLayouts(userGroupId, userId);
        }
    }

    public void copyUserGroupLayouts(long[] userGroupIds, long userId) throws PortalException, SystemException {
        for (long userGroupId : userGroupIds) {
            if (this.userGroupPersistence.containsUser(userGroupId, userId)) continue;
            this.copyUserGroupLayouts(userGroupId, userId);
        }
    }

    public void copyUserGroupLayouts(long userGroupId, long userId) throws PortalException, SystemException {
        UnsyncByteArrayInputStream ubais;
        byte[] bytes;
        long targetGroupId;
        long sourceGroupId;
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(userGroupId);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Map<String, String[]> parameterMap = this.getLayoutTemplatesParameters();
        if (userGroup.hasPrivateLayouts()) {
            sourceGroupId = userGroup.getGroup().getGroupId();
            targetGroupId = user.getGroup().getGroupId();
            bytes = this.layoutLocalService.exportLayouts(sourceGroupId, true, parameterMap, null, null);
            ubais = new UnsyncByteArrayInputStream(bytes);
            this.layoutLocalService.importLayouts(userId, targetGroupId, true, parameterMap, (InputStream)ubais);
        }
        if (userGroup.hasPublicLayouts()) {
            sourceGroupId = userGroup.getGroup().getGroupId();
            targetGroupId = user.getGroup().getGroupId();
            bytes = this.layoutLocalService.exportLayouts(sourceGroupId, false, parameterMap, null, null);
            ubais = new UnsyncByteArrayInputStream(bytes);
            this.layoutLocalService.importLayouts(userId, targetGroupId, false, parameterMap, (InputStream)ubais);
        }
    }

    @Override
    public void deleteUserGroup(long userGroupId) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        if (this.userLocalService.getUserGroupUsersCount(userGroupId, true) > 0) {
            throw new RequiredUserGroupException();
        }
        this.clearUserUserGroups(userGroupId);
        Group group = userGroup.getGroup();
        this.groupLocalService.deleteGroup(group.getGroupId());
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByUserGroupId(userGroupId);
        this.resourceLocalService.deleteResource(userGroup.getCompanyId(), UserGroup.class.getName(), 4, userGroup.getUserGroupId());
        this.userGroupPersistence.remove(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public UserGroup getUserGroup(long userGroupId) throws PortalException, SystemException {
        return this.userGroupPersistence.findByPrimaryKey(userGroupId);
    }

    public UserGroup getUserGroup(long companyId, String name) throws PortalException, SystemException {
        return this.userGroupPersistence.findByC_N(companyId, name);
    }

    public List<UserGroup> getUserGroups(long companyId) throws SystemException {
        return this.userGroupPersistence.findByCompanyId(companyId);
    }

    public List<UserGroup> getUserGroups(long[] userGroupIds) throws PortalException, SystemException {
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(userGroupIds.length);
        for (long userGroupId : userGroupIds) {
            UserGroup userGroup = this.getUserGroup(userGroupId);
            userGroups.add(userGroup);
        }
        return userGroups;
    }

    public List<UserGroup> getUserUserGroups(long userId) throws SystemException {
        return this.userPersistence.getUserGroups(userId);
    }

    public boolean hasGroupUserGroup(long groupId, long userGroupId) throws SystemException {
        return this.groupPersistence.containsUserGroup(groupId, userGroupId);
    }

    public List<UserGroup> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userGroupFinder.findByC_N_D(companyId, name, description, params, start, end, obc);
    }

    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params) throws SystemException {
        return this.userGroupFinder.countByC_N_D(companyId, name, description, params);
    }

    public void setUserUserGroups(long userId, long[] userGroupIds) throws PortalException, SystemException {
        this.copyUserGroupLayouts(userGroupIds, userId);
        this.userPersistence.setUserGroups(userId, userGroupIds);
        try {
            UserIndexer.updateUsers(new long[]{userId});
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws SystemException {
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupIds, groupId);
        this.groupPersistence.removeUserGroups(groupId, userGroupIds);
        PermissionCacheUtil.clearCache();
    }

    public UserGroup updateUserGroup(long companyId, long userGroupId, String name, String description) throws PortalException, SystemException {
        this.validate(userGroupId, companyId, name);
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        userGroup.setName(name);
        userGroup.setDescription(description);
        this.userGroupPersistence.update((BaseModel)userGroup, false);
        return userGroup;
    }

    protected Map<String, String[]> getLayoutTemplatesParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"MERGE_BY_LAYOUT_NAME"});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLETS_MERGE_MODE", new String[]{"ADD_TO_BOTTOM"});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        return parameterMap;
    }

    protected void validate(long userGroupId, long companyId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(",") != -1 || name.indexOf("*") != -1) {
            throw new UserGroupNameException();
        }
        try {
            UserGroup userGroup = this.userGroupFinder.findByC_N(companyId, name);
            if (userGroup.getUserGroupId() != userGroupId) {
                throw new DuplicateUserGroupException();
            }
        }
        catch (NoSuchUserGroupException nsuge) {
            // empty catch block
        }
    }
}

