/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchUserGroupRoleException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.UserGroupRoleLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupRoleLocalServiceImpl
extends UserGroupRoleLocalServiceBaseImpl {
    public void addUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException, SystemException {
        this.checkGroupResource(groupId);
        for (long roleId : roleIds) {
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(pk);
            if (userGroupRole != null) continue;
            userGroupRole = this.userGroupRolePersistence.create(pk);
            this.userGroupRolePersistence.update((BaseModel)userGroupRole, false);
        }
        PermissionCacheUtil.clearCache();
    }

    public void addUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException, SystemException {
        this.checkGroupResource(groupId);
        for (long userId : userIds) {
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(pk);
            if (userGroupRole != null) continue;
            userGroupRole = this.userGroupRolePersistence.create(pk);
            this.userGroupRolePersistence.update((BaseModel)userGroupRole, false);
        }
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUserGroupRole(UserGroupRole userGroupRole) throws SystemException {
        this.userGroupRolePersistence.remove((BaseModel)userGroupRole);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) throws SystemException {
        for (long roleId : roleIds) {
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupRoleException nsugre) {
                // empty catch block
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long userId, long[] groupIds) throws SystemException {
        for (long groupId : groupIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId) throws SystemException {
        for (long userId : userIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) throws SystemException {
        for (long userId : userIds) {
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupRoleException nsugre) {
                // empty catch block
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByGroupId(long groupId) throws SystemException {
        this.userGroupRolePersistence.removeByGroupId(groupId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByRoleId(long roleId) throws SystemException {
        this.userGroupRolePersistence.removeByRoleId(roleId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByUserId(long userId) throws SystemException {
        this.userGroupRolePersistence.removeByUserId(userId);
        PermissionCacheUtil.clearCache();
    }

    public List<UserGroupRole> getUserGroupRoles(long userId) throws SystemException {
        return this.userGroupRolePersistence.findByUserId(userId);
    }

    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId) throws SystemException {
        return this.userGroupRolePersistence.findByU_G(userId, groupId);
    }

    public List<UserGroupRole> getUserGroupRolesByGroupAndRole(long groupId, long roleId) throws SystemException {
        return this.userGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public List<UserGroupRole> getUserGroupRolesByUserUserGroupAndGroup(long userId, long groupId) throws SystemException {
        return this.userGroupRoleFinder.findByUserUserGroupGroupRole(userId, groupId);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId) throws SystemException {
        return this.hasUserGroupRole(userId, groupId, roleId, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId, boolean inherit) throws SystemException {
        UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(pk);
        if (userGroupRole != null) {
            return true;
        }
        return inherit && this.roleFinder.countByU_G_R(userId, groupId, roleId) > 0;
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName) throws PortalException, SystemException {
        return this.hasUserGroupRole(userId, groupId, roleName, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName, boolean inherit) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long companyId = user.getCompanyId();
        Role role = this.rolePersistence.findByC_N(companyId, roleName);
        long roleId = role.getRoleId();
        return this.hasUserGroupRole(userId, groupId, roleId, inherit);
    }

    protected void checkGroupResource(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        this.resourceLocalService.addResource(group.getCompanyId(), Group.class.getName(), 4, String.valueOf(groupId));
    }
}

