/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.UserGroupRoleServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;

public class UserGroupRoleServiceImpl
extends UserGroupRoleServiceBaseImpl {
    public void addUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCommunityOwner(groupId) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_USER_ROLES")) {
            throw new PrincipalException();
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, roleIds);
    }

    public void addUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCommunityOwner(groupId) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_USER_ROLES")) {
            throw new PrincipalException();
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userIds, groupId, roleId);
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCommunityOwner(groupId)) {
            throw new PrincipalException();
        }
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupId, roleIds);
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCommunityOwner(groupId) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_USER_ROLES")) {
            throw new PrincipalException();
        }
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, roleId);
    }
}

