/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.UserGroupServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupServiceImpl
extends UserGroupServiceBaseImpl {
    public void addGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.addGroupUserGroups(groupId, userGroupIds);
    }

    public UserGroup addUserGroup(String name, String description) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_USER_GROUP");
        User user = this.getUser();
        return this.userGroupLocalService.addUserGroup(user.getUserId(), user.getCompanyId(), name, description);
    }

    public void deleteUserGroup(long userGroupId) throws PortalException, SystemException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"DELETE");
        this.userGroupLocalService.deleteUserGroup(userGroupId);
    }

    public UserGroup getUserGroup(long userGroupId) throws PortalException, SystemException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"VIEW");
        return this.userGroupLocalService.getUserGroup(userGroupId);
    }

    public UserGroup getUserGroup(String name) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(this.getUser().getCompanyId(), name);
        long userGroupId = userGroup.getUserGroupId();
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"VIEW");
        return userGroup;
    }

    public List<UserGroup> getUserUserGroups(long userId) throws SystemException {
        return this.userGroupLocalService.getUserUserGroups(userId);
    }

    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetGroupUserGroups(groupId, userGroupIds);
    }

    public UserGroup updateUserGroup(long userGroupId, String name, String description) throws PortalException, SystemException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"UPDATE");
        return this.userGroupLocalService.updateUserGroup(this.getUser().getCompanyId(), userGroupId, name, description);
    }
}

