/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.ContactBirthdayException;
import com.liferay.portal.ContactFirstNameException;
import com.liferay.portal.ContactFullNameException;
import com.liferay.portal.ContactLastNameException;
import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.DuplicateUserScreenNameException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.NoSuchContactException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.PortalException;
import com.liferay.portal.RequiredUserException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.ReservedUserScreenNameException;
import com.liferay.portal.SystemException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserPortraitException;
import com.liferay.portal.UserReminderQueryException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.UserSmsException;
import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.ContactConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.FullNameValidator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidator;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.security.pwd.PwdToolkitUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.PrincipalBean;
import com.liferay.portal.service.base.UserLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import com.liferay.portlet.enterpriseadmin.util.UserIndexer;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.imagegallery.ImageSizeException;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLocalServiceImpl
extends UserLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(UserLocalServiceImpl.class);
    private static Map<Long, User> _defaultUsers = new ConcurrentHashMap<Long, User>();

    public void addDefaultGroups(long userId) throws PortalException, SystemException {
        String[] defaultGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> groupIdsSet = new HashSet<Long>();
        for (String defaultGroupName : defaultGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.group.names", "\n", PropsValues.ADMIN_DEFAULT_GROUP_NAMES)) {
            try {
                Group group = this.groupPersistence.findByC_N(user.getCompanyId(), defaultGroupName);
                if (this.userPersistence.containsGroup(userId, group.getGroupId())) continue;
                groupIdsSet.add(group.getGroupId());
            }
            catch (NoSuchGroupException nsge) {
                // empty catch block
            }
        }
        long[] groupIds = ArrayUtil.toArray((Long[])groupIdsSet.toArray(new Long[groupIdsSet.size()]));
        this.groupLocalService.addUserGroups(userId, groupIds);
    }

    public void addDefaultRoles(long userId) throws PortalException, SystemException {
        String[] defaultRoleNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> roleIdSet = new HashSet<Long>();
        for (String defaultRoleName : defaultRoleNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.role.names", "\n", PropsValues.ADMIN_DEFAULT_ROLE_NAMES)) {
            try {
                Role role = this.rolePersistence.findByC_N(user.getCompanyId(), defaultRoleName);
                if (this.userPersistence.containsRole(userId, role.getRoleId())) continue;
                roleIdSet.add(role.getRoleId());
            }
            catch (NoSuchRoleException nsre) {
                // empty catch block
            }
        }
        long[] roleIds = ArrayUtil.toArray((Long[])roleIdSet.toArray(new Long[roleIdSet.size()]));
        roleIds = EnterpriseAdminUtil.addRequiredRoles(user, roleIds);
        this.userPersistence.addRoles(userId, roleIds);
    }

    public void addDefaultUserGroups(long userId) throws PortalException, SystemException {
        long[] userGroupIds;
        String[] defaultUserGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> userGroupIdSet = new HashSet<Long>();
        for (String defaultUserGroupName : defaultUserGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.user.group.names", "\n", PropsValues.ADMIN_DEFAULT_USER_GROUP_NAMES)) {
            try {
                UserGroup userGroup = this.userGroupPersistence.findByC_N(user.getCompanyId(), defaultUserGroupName);
                if (this.userPersistence.containsUserGroup(userId, userGroup.getUserGroupId())) continue;
                userGroupIdSet.add(userGroup.getUserGroupId());
            }
            catch (NoSuchUserGroupException nsuge) {
                // empty catch block
            }
        }
        for (long userGroupId : userGroupIds = ArrayUtil.toArray((Long[])userGroupIdSet.toArray(new Long[userGroupIdSet.size()]))) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userId);
        }
        this.userPersistence.setUserGroups(userId, userGroupIds);
    }

    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        this.groupPersistence.addUsers(groupId, userIds);
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Role role = this.rolePersistence.findByC_N(group.getCompanyId(), "Community Member");
        for (long userId : userIds) {
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, new long[]{role.getRoleId()});
        }
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        this.organizationPersistence.addUsers(organizationId, userIds);
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        Group group = organization.getGroup();
        long groupId = group.getGroupId();
        Role role = this.rolePersistence.findByC_N(group.getCompanyId(), "Organization Member");
        for (long userId : userIds) {
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, new long[]{role.getRoleId()});
        }
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws SystemException {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void addRoleUsers(long roleId, long[] userIds) throws SystemException {
        this.rolePersistence.addUsers(roleId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        this.userGroupPersistence.addUsers(userGroupId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public User addUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        screenName = this.getScreenName(screenName);
        emailAddress = emailAddress.trim().toLowerCase();
        openId = openId.trim();
        Date now = new Date();
        if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
            autoScreenName = true;
        }
        long userId = this.counterLocalService.increment();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(companyId, userId);
        }
        this.validate(companyId, userId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, firstName, middleName, lastName, organizationIds);
        if (autoPassword) {
            password1 = PwdToolkitUtil.generate();
        } else if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException(3);
        }
        if (autoScreenName) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            try {
                screenName = screenNameGenerator.generate(companyId, userId, emailAddress);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        User defaultUser = this.getDefaultUser(companyId);
        String fullName = ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName);
        String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)(" " + fullName), (boolean)false);
        User user = this.userPersistence.create(userId);
        user.setCompanyId(companyId);
        user.setCreateDate(now);
        user.setModifiedDate(now);
        user.setDefaultUser(false);
        user.setContactId(this.counterLocalService.increment());
        user.setPassword(PwdEncryptor.encrypt(password1));
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(false);
        user.setScreenName(screenName);
        user.setEmailAddress(emailAddress);
        user.setOpenId(openId);
        user.setLanguageId(locale.toString());
        user.setTimeZoneId(defaultUser.getTimeZoneId());
        user.setGreeting(greeting);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setActive(true);
        this.userPersistence.update((BaseModel)user, false);
        String creatorUserName = "";
        if (creatorUserId <= 0L) {
            creatorUserId = user.getUserId();
        } else {
            User creatorUser = this.userPersistence.findByPrimaryKey(creatorUserId);
            creatorUserName = creatorUser.getFullName();
        }
        this.resourceLocalService.addResources(companyId, 0L, creatorUserId, User.class.getName(), user.getUserId(), false, false, false);
        user.setExpandoBridgeAttributes(serviceContext);
        if (user.hasCompanyMx()) {
            this.mailService.addUser(companyId, userId, password1, firstName, middleName, lastName, emailAddress);
        }
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (PortalException)new ContactBirthdayException());
        Contact contact = this.contactPersistence.create(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(creatorUserId);
        contact.setUserName(creatorUserName);
        contact.setCreateDate(now);
        contact.setModifiedDate(now);
        contact.setAccountId(company.getAccountId());
        contact.setParentContactId(0L);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, false);
        this.groupLocalService.addGroup(user.getUserId(), User.class.getName(), user.getUserId(), null, null, 0, "/" + screenName, true, null);
        if (groupIds != null) {
            this.groupLocalService.addUserGroups(userId, groupIds);
        }
        this.addDefaultGroups(userId);
        this.updateOrganizations(userId, organizationIds);
        if (roleIds != null) {
            roleIds = EnterpriseAdminUtil.addRequiredRoles(user, roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.addDefaultRoles(userId);
        if (userGroupIds != null) {
            for (long userGroupId : userGroupIds) {
                this.userGroupLocalService.copyUserGroupLayouts(userGroupId, new long[]{userId});
            }
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.addDefaultUserGroups(userId);
        if (sendEmail) {
            try {
                this.sendEmail(user, password1);
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
        if (serviceContext != null) {
            this.updateTagsAsset(creatorUserId, user, serviceContext.getTagsEntries());
        }
        try {
            UserIndexer.updateUser(user);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        return user;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        return this.authenticate(companyId, emailAddress, password, "emailAddress", headerMap, parameterMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        return this.authenticate(companyId, screenName, password, "screenName", headerMap, parameterMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        return this.authenticate(companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long authenticateForBasic(long companyId, String authType, String login, String password) throws PortalException, SystemException {
        try {
            User user = null;
            if (authType.equals("emailAddress")) {
                user = this.getUserByEmailAddress(companyId, login);
            } else if (authType.equals("screenName")) {
                user = this.getUserByScreenName(companyId, login);
            } else if (authType.equals("userId")) {
                user = this.getUserById(companyId, GetterUtil.getLong((String)login));
            }
            if (!PropsValues.BASIC_AUTH_PASSWORD_REQUIRED) {
                return user.getUserId();
            }
            String userPassword = user.getPassword();
            if (!user.isPasswordEncrypted()) {
                userPassword = PwdEncryptor.encrypt(userPassword);
            }
            String encPassword = PwdEncryptor.encrypt(password);
            if (userPassword.equals(password) || userPassword.equals(encPassword)) {
                return user.getUserId();
            }
        }
        catch (NoSuchUserException nsue) {
            // empty catch block
        }
        return 0L;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean authenticateForJAAS(long userId, String encPassword) {
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            if (user.isDefaultUser()) {
                _log.error((Object)"The default user should never be allowed to authenticate");
                return false;
            }
            String password = user.getPassword();
            if (user.isPasswordEncrypted()) {
                if (password.equals(encPassword)) {
                    return true;
                }
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && password.equals(encPassword = PwdEncryptor.encrypt(encPassword, password))) {
                    return true;
                }
            } else {
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && password.equals(encPassword)) {
                    return true;
                }
                if ((password = PwdEncryptor.encrypt(password)).equals(encPassword)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return false;
    }

    public void checkLockout(User user) throws PortalException, SystemException {
        if (PortalLDAPUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy.isLockout()) {
            long requiredElapsedTime;
            long elapsedTime;
            Date now = new Date();
            int failedLoginAttempts = user.getFailedLoginAttempts();
            if (failedLoginAttempts > 0) {
                long failedLoginTime = user.getLastFailedLoginDate().getTime();
                elapsedTime = now.getTime() - failedLoginTime;
                requiredElapsedTime = passwordPolicy.getResetFailureCount() * 1000L;
                if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                    user.setLastFailedLoginDate(null);
                    user.setFailedLoginAttempts(0);
                }
            }
            if (user.isLockout()) {
                long lockoutTime = user.getLockoutDate().getTime();
                elapsedTime = now.getTime() - lockoutTime;
                requiredElapsedTime = passwordPolicy.getLockoutDuration() * 1000L;
                if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                    user.setLockout(false);
                    user.setLockoutDate(null);
                }
            }
            if (user.isLockout()) {
                throw new UserLockoutException();
            }
        }
    }

    public void checkLoginFailure(User user) throws SystemException {
        Date now = new Date();
        int failedLoginAttempts = user.getFailedLoginAttempts();
        user.setLastFailedLoginDate(now);
        user.setFailedLoginAttempts(++failedLoginAttempts);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void checkLoginFailureByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureById(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        this.checkLoginFailure(user);
    }

    public void checkPasswordExpired(User user) throws PortalException, SystemException {
        if (PortalLDAPUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (this.isPasswordExpired(user)) {
            int graceLoginCount = user.getGraceLoginCount();
            if (graceLoginCount < passwordPolicy.getGraceLimit()) {
                user.setGraceLoginCount(++graceLoginCount);
                this.userPersistence.update((BaseModel)user, false);
            } else {
                throw new PasswordExpiredException();
            }
        }
        if (this.isPasswordExpiringSoon(user)) {
            user.setPasswordReset(true);
            this.userPersistence.update((BaseModel)user, false);
        }
        if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired() && user.getLastLoginDate() == null) {
            boolean passwordReset = false;
            if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                passwordReset = true;
            }
            user.setPasswordReset(passwordReset);
            this.userPersistence.update((BaseModel)user, false);
        }
    }

    public void clearOrganizationUsers(long organizationId) throws SystemException {
        this.organizationPersistence.clearUsers(organizationId);
        PermissionCacheUtil.clearCache();
    }

    public void clearUserGroupUsers(long userGroupId) throws SystemException {
        this.userGroupPersistence.clearUsers(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    public KeyValuePair decryptUserId(long companyId, String name, String password) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        try {
            name = Encryptor.decrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            password = Encryptor.decrypt((Key)company.getKeyObj(), (String)password);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        String encPassword = PwdEncryptor.encrypt(password);
        if (user.getPassword().equals(encPassword)) {
            if (this.isPasswordExpired(user)) {
                user.setPasswordReset(true);
                this.userPersistence.update((BaseModel)user, false);
            }
            return new KeyValuePair(name, password);
        }
        throw new PrincipalException();
    }

    public void deletePasswordPolicyUser(long passwordPolicyId, long userId) throws SystemException {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(passwordPolicyId, User.class.getName(), userId);
    }

    public void deletePortrait(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long portraitId = user.getPortraitId();
        if (portraitId > 0L) {
            user.setPortraitId(0L);
            this.userPersistence.update((BaseModel)user, false);
            this.imageLocalService.deleteImage(portraitId);
        }
    }

    public void deleteRoleUser(long roleId, long userId) throws SystemException {
        this.rolePersistence.removeUser(roleId, userId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUser(long userId) throws PortalException, SystemException {
        if (!PropsValues.USERS_DELETE) {
            throw new RequiredUserException();
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            UserIndexer.deleteUser(user.getCompanyId(), user.getUserId());
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        this.browserTrackerLocalService.deleteUserBrowserTracker(userId);
        Group group = user.getGroup();
        if (group != null) {
            this.groupLocalService.deleteGroup(group.getGroupId());
        }
        this.imageLocalService.deleteImage(user.getPortraitId());
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(User.class.getName(), userId);
        this.passwordTrackerLocalService.deletePasswordTrackers(userId);
        this.subscriptionLocalService.deleteSubscriptions(userId);
        this.userIdMapperLocalService.deleteUserIdMappers(userId);
        this.announcementsDeliveryLocalService.deleteDeliveries(userId);
        this.blogsStatsUserLocalService.deleteStatsUserByUserId(userId);
        this.dlFileRankLocalService.deleteFileRanks(userId);
        this.expandoValueLocalService.deleteValues(User.class.getName(), userId);
        this.mbBanLocalService.deleteBansByBanUserId(userId);
        this.mbMessageFlagLocalService.deleteFlags(userId);
        this.mbStatsUserLocalService.deleteStatsUsersByUserId(userId);
        this.shoppingCartLocalService.deleteUserCarts(userId);
        this.socialActivityLocalService.deleteUserActivities(userId);
        this.socialRequestLocalService.deleteReceiverUserRequests(userId);
        this.socialRequestLocalService.deleteUserRequests(userId);
        this.tagsAssetLocalService.deleteAsset(User.class.getName(), userId);
        this.mailService.deleteUser(user.getCompanyId(), userId);
        try {
            this.contactLocalService.deleteContact(user.getContactId());
        }
        catch (NoSuchContactException nsce) {
            // empty catch block
        }
        this.resourceLocalService.deleteResource(user.getCompanyId(), User.class.getName(), 4, user.getUserId());
        this.userGroupRoleLocalService.deleteUserGroupRolesByUserId(userId);
        this.userPersistence.remove(userId);
        PermissionCacheUtil.clearCache();
    }

    public String encryptUserId(String name) throws PortalException, SystemException {
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        try {
            return Encryptor.encrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
    }

    public User getDefaultUser(long companyId) throws PortalException, SystemException {
        User userModel = _defaultUsers.get(companyId);
        if (userModel == null) {
            userModel = this.userPersistence.findByC_DU(companyId, true);
            _defaultUsers.put(companyId, userModel);
        }
        return userModel;
    }

    public long getDefaultUserId(long companyId) throws PortalException, SystemException {
        User user = this.getDefaultUser(companyId);
        return user.getUserId();
    }

    public long[] getGroupUserIds(long groupId) throws SystemException {
        return this.getUserIds(this.getGroupUsers(groupId));
    }

    public List<User> getGroupUsers(long groupId) throws SystemException {
        return this.groupPersistence.getUsers(groupId);
    }

    public int getGroupUsersCount(long groupId) throws SystemException {
        return this.groupPersistence.getUsersSize(groupId);
    }

    public int getGroupUsersCount(long groupId, boolean active) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", new Long(groupId));
        return this.searchCount(group.getCompanyId(), null, active, params);
    }

    public List<User> getNoAnnouncementsDeliveries(String type) throws SystemException {
        return this.userFinder.findByNoAnnouncementsDeliveries(type);
    }

    public List<User> getNoContacts() throws SystemException {
        return this.userFinder.findByNoContacts();
    }

    public List<User> getNoGroups() throws SystemException {
        return this.userFinder.findByNoGroups();
    }

    public long[] getOrganizationUserIds(long organizationId) throws SystemException {
        return this.getUserIds(this.getOrganizationUsers(organizationId));
    }

    public List<User> getOrganizationUsers(long organizationId) throws SystemException {
        return this.organizationPersistence.getUsers(organizationId);
    }

    public int getOrganizationUsersCount(long organizationId) throws SystemException {
        return this.organizationPersistence.getUsersSize(organizationId);
    }

    public int getOrganizationUsersCount(long organizationId, boolean active) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersOrgs", new Long(organizationId));
        return this.searchCount(organization.getCompanyId(), null, active, params);
    }

    public long[] getRoleUserIds(long roleId) throws SystemException {
        return this.getUserIds(this.getRoleUsers(roleId));
    }

    public List<User> getRoleUsers(long roleId) throws SystemException {
        return this.rolePersistence.getUsers(roleId);
    }

    public List<User> getRoleUsers(long roleId, int start, int end) throws SystemException {
        return this.rolePersistence.getUsers(roleId, start, end);
    }

    public int getRoleUsersCount(long roleId) throws SystemException {
        return this.rolePersistence.getUsersSize(roleId);
    }

    public int getRoleUsersCount(long roleId, boolean active) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersRoles", new Long(roleId));
        return this.searchCount(role.getCompanyId(), null, active, params);
    }

    public List<User> getSocialUsers(long userId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelation", new Long[]{userId});
        return this.search(user.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId, int type, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[]{userId, new Long(type)});
        return this.search(user.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.search(user1.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int type, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, new Long(type), userId2, new Long(type)});
        return this.search(user1.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public int getSocialUsersCount(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelation", new Long[]{userId});
        return this.searchCount(user.getCompanyId(), null, true, params);
    }

    public int getSocialUsersCount(long userId, int type) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[]{userId, new Long(type)});
        return this.searchCount(user.getCompanyId(), null, true, params);
    }

    public int getSocialUsersCount(long userId1, long userId2) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.searchCount(user1.getCompanyId(), null, true, params);
    }

    public int getSocialUsersCount(long userId1, long userId2, int type) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, new Long(type), userId2, new Long(type)});
        return this.searchCount(user1.getCompanyId(), null, true, params);
    }

    public List<User> getUserGroupUsers(long userGroupId) throws SystemException {
        return this.userGroupPersistence.getUsers(userGroupId);
    }

    public int getUserGroupUsersCount(long userGroupId) throws SystemException {
        return this.userGroupPersistence.getUsersSize(userGroupId);
    }

    public int getUserGroupUsersCount(long userGroupId, boolean active) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersUserGroups", new Long(userGroupId));
        return this.searchCount(userGroup.getCompanyId(), null, active, params);
    }

    public User getUserByContactId(long contactId) throws PortalException, SystemException {
        return this.userPersistence.findByContactId(contactId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        emailAddress = emailAddress.trim().toLowerCase();
        return this.userPersistence.findByC_EA(companyId, emailAddress);
    }

    public User getUserById(long userId) throws PortalException, SystemException {
        return this.userPersistence.findByPrimaryKey(userId);
    }

    public User getUserById(long companyId, long userId) throws PortalException, SystemException {
        return this.userPersistence.findByC_U(companyId, userId);
    }

    public User getUserByOpenId(String openId) throws PortalException, SystemException {
        return this.userPersistence.findByOpenId(openId);
    }

    public User getUserByPortraitId(long portraitId) throws PortalException, SystemException {
        return this.userPersistence.findByPortraitId(portraitId);
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        screenName = this.getScreenName(screenName);
        return this.userPersistence.findByC_SN(companyId, screenName);
    }

    public User getUserByUuid(String uuid) throws PortalException, SystemException {
        List users = this.userPersistence.findByUuid(uuid);
        if (users.isEmpty()) {
            throw new NoSuchUserException();
        }
        return (User)users.get(0);
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        emailAddress = emailAddress.trim().toLowerCase();
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        screenName = this.getScreenName(screenName);
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return user.getUserId();
    }

    public boolean hasGroupUser(long groupId, long userId) throws SystemException {
        return this.groupPersistence.containsUser(groupId, userId);
    }

    public boolean hasOrganizationUser(long organizationId, long userId) throws SystemException {
        return this.organizationPersistence.containsUser(organizationId, userId);
    }

    public boolean hasPasswordPolicyUser(long passwordPolicyId, long userId) throws SystemException {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, User.class.getName(), userId);
    }

    public boolean hasRoleUser(long roleId, long userId) throws SystemException {
        return this.rolePersistence.containsUser(roleId, userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException, SystemException {
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean hasUserGroupUser(long userGroupId, long userId) throws SystemException {
        return this.userGroupPersistence.containsUser(userGroupId, userId);
    }

    public boolean isPasswordExpired(User user) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy.getExpireable()) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user, false);
            }
            long passwordStartTime = user.getPasswordModifiedDate().getTime();
            long elapsedTime = now.getTime() - passwordStartTime;
            return elapsedTime > passwordPolicy.getMaxAge() * 1000L;
        }
        return false;
    }

    public boolean isPasswordExpiringSoon(User user) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy.isExpireable()) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user, false);
            }
            long timeModified = user.getPasswordModifiedDate().getTime();
            long passwordExpiresOn = passwordPolicy.getMaxAge() * 1000L + timeModified;
            long timeStartWarning = passwordExpiresOn - passwordPolicy.getWarningTime() * 1000L;
            return now.getTime() > timeStartWarning;
        }
        return false;
    }

    public void reIndex(long userId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            UserIndexer.updateUsers(new long[]{userId});
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexUsers(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String screenName = null;
        String emailAddress = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            screenName = keywords;
            emailAddress = keywords;
        } else {
            andOperator = true;
        }
        return this.search(companyId, firstName, middleName, lastName, screenName, emailAddress, active, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "125");
            if (active != null) {
                contextQuery.addRequiredTerm("active", active);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)firstName)) {
                if (andSearch) {
                    searchQuery.addRequiredTerm("firstName", firstName, true);
                } else {
                    searchQuery.addTerm("firstName", firstName, true);
                }
            }
            if (Validator.isNotNull((String)middleName)) {
                if (andSearch) {
                    searchQuery.addRequiredTerm("middleName", middleName, true);
                } else {
                    searchQuery.addTerm("middleName", middleName, true);
                }
            }
            if (Validator.isNotNull((String)lastName)) {
                if (andSearch) {
                    searchQuery.addRequiredTerm("lastName", lastName, true);
                } else {
                    searchQuery.addTerm("lastName", lastName, true);
                }
            }
            if (Validator.isNotNull((String)screenName)) {
                if (andSearch) {
                    searchQuery.addRequiredTerm("screenName", screenName, true);
                } else {
                    searchQuery.addTerm("screenName", screenName, true);
                }
            }
            if (Validator.isNotNull((String)emailAddress)) {
                if (andSearch) {
                    searchQuery.addRequiredTerm("emailAddress", emailAddress, true);
                } else {
                    searchQuery.addTerm("emailAddress", emailAddress, true);
                }
            }
            this.populateQuery(contextQuery, searchQuery, params, andSearch);
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (Query)fullQuery, (Sort)sort, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public List<User> search(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userFinder.findByKeywords(companyId, keywords, active, params, start, end, obc);
    }

    public List<User> search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userFinder.findByC_FN_MN_LN_SN_EA_A(companyId, firstName, middleName, lastName, screenName, emailAddress, active, params, andSearch, start, end, obc);
    }

    public int searchCount(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params) throws SystemException {
        return this.userFinder.countByKeywords(companyId, keywords, active, params);
    }

    public int searchCount(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andSearch) throws SystemException {
        return this.userFinder.countByC_FN_MN_LN_SN_EA_A(companyId, firstName, middleName, lastName, screenName, emailAddress, active, params, andSearch);
    }

    public void sendPassword(long companyId, String emailAddress, String remoteAddr, String remoteHost, String userAgent, String fromName, String fromAddress, String subject, String body) throws PortalException, SystemException {
        try {
            this.doSendPassword(companyId, emailAddress, remoteAddr, remoteHost, userAgent, fromName, fromAddress, subject, body);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void setRoleUsers(long roleId, long[] userIds) throws SystemException {
        this.rolePersistence.setUsers(roleId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        this.userGroupPersistence.setUsers(userGroupId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupUsers(long groupId, long[] userIds) throws SystemException {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId);
        this.groupPersistence.removeUsers(groupId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        Group group = organization.getGroup();
        long groupId = group.getGroupId();
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId);
        this.organizationPersistence.removeUsers(organizationId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws SystemException {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        if (role.getName().equals("User")) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetRoleUsers(long roleId, List<User> users) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        if (role.getName().equals("User")) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, users);
        try {
            UserIndexer.updateUsers(users);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + ListUtil.toString(users, (String)"userId")), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws SystemException {
        this.userGroupPersistence.removeUsers(userGroupId, userIds);
        try {
            UserIndexer.updateUsers(userIds);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + StringUtil.merge((long[])userIds)), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public User updateActive(long userId, boolean active) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setActive(active);
        this.userPersistence.update((BaseModel)user, false);
        try {
            UserIndexer.updateUsers(new long[]{userId});
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        return user;
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setAgreedToTermsOfUse(agreedToTermsOfUse);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateCreateDate(long userId, Date createDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setCreateDate(createDate);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2) throws PortalException, SystemException {
        if (!(emailAddress1 = emailAddress1.trim().toLowerCase()).equals(emailAddress2 = emailAddress2.trim().toLowerCase())) {
            throw new UserEmailAddressException();
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user.getCompanyId(), emailAddress1);
        this.validateEmailAddress(user.getCompanyId(), emailAddress2);
        if (!user.getEmailAddress().equalsIgnoreCase(emailAddress1) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress1) != null) {
            throw new DuplicateUserEmailAddressException();
        }
        this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updateGroups(long userId, long[] newGroupIds) throws PortalException, SystemException {
        if (newGroupIds == null) {
            return;
        }
        List oldGroups = this.userPersistence.getGroups(userId);
        ArrayList<Long> oldGroupIds = new ArrayList<Long>(oldGroups.size());
        for (Group oldGroup : oldGroups) {
            long oldGroupId = oldGroup.getGroupId();
            oldGroupIds.add(oldGroupId);
            if (ArrayUtil.contains((long[])newGroupIds, (long)oldGroupId)) continue;
            this.unsetGroupUsers(oldGroupId, new long[]{userId});
        }
        for (long newGroupId : newGroupIds) {
            if (oldGroupIds.contains(newGroupId)) continue;
            this.addGroupUsers(newGroupId, new long[]{userId});
        }
        try {
            UserIndexer.updateUsers(new long[]{userId});
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public User updateLastLogin(long userId, String loginIP) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date lastLoginDate = user.getLoginDate();
        if (lastLoginDate == null) {
            lastLoginDate = new Date();
        }
        user.setLoginDate(new Date());
        user.setLoginIP(loginIP);
        user.setLastLoginDate(lastLoginDate);
        user.setLastLoginIP(user.getLoginIP());
        user.setLastFailedLoginDate(null);
        user.setFailedLoginAttempts(0);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateLockout(User user, boolean lockout) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy == null || !passwordPolicy.isLockout()) {
            return user;
        }
        Date lockoutDate = null;
        if (lockout) {
            lockoutDate = new Date();
        }
        user.setLockout(lockout);
        user.setLockoutDate(lockoutDate);
        if (!lockout) {
            user.setLastFailedLoginDate(lockoutDate);
            user.setFailedLoginAttempts(0);
        }
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateLockoutByEmailAddress(long companyId, String emailAddress, boolean lockout) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutByScreenName(long companyId, String screenName, boolean lockout) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        return this.updateLockout(user, lockout);
    }

    public User updateModifiedDate(long userId, Date modifiedDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setModifiedDate(modifiedDate);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updateOpenId(long userId, String openId) throws PortalException, SystemException {
        openId = openId.trim();
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setOpenId(openId);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updateOrganizations(long userId, long[] newOrganizationIds) throws PortalException, SystemException {
        if (newOrganizationIds == null) {
            return;
        }
        List oldOrganizations = this.userPersistence.getOrganizations(userId);
        ArrayList<Long> oldOrganizationIds = new ArrayList<Long>(oldOrganizations.size());
        for (Organization oldOrganization : oldOrganizations) {
            long oldOrganizationId = oldOrganization.getOrganizationId();
            oldOrganizationIds.add(oldOrganizationId);
            if (ArrayUtil.contains((long[])newOrganizationIds, (long)oldOrganizationId)) continue;
            this.unsetOrganizationUsers(oldOrganizationId, new long[]{userId});
        }
        for (long newOrganizationId : newOrganizationIds) {
            if (oldOrganizationIds.contains(newOrganizationId)) continue;
            this.addOrganizationUsers(newOrganizationId, new long[]{userId});
        }
        try {
            UserIndexer.updateUsers(new long[]{userId});
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException, SystemException {
        return this.updatePassword(userId, password1, password2, passwordReset, false);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset, boolean silentUpdate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!silentUpdate) {
            this.validatePassword(user.getCompanyId(), userId, password1, password2);
        }
        String oldEncPwd = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            oldEncPwd = PwdEncryptor.encrypt(user.getPassword());
        }
        String newEncPwd = PwdEncryptor.encrypt(password1);
        if (user.hasCompanyMx()) {
            this.mailService.updatePassword(user.getCompanyId(), userId, password1);
        }
        user.setPassword(newEncPwd);
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(new Date());
        user.setGraceLoginCount(0);
        if (!silentUpdate) {
            user.setPasswordModified(true);
        }
        try {
            this.userPersistence.update((BaseModel)user, false);
        }
        catch (ModelListenerException mle) {
            String passwordHistory;
            String msg = GetterUtil.getString((String)mle.getCause().getMessage());
            if (PortalLDAPUtil.isPasswordPolicyEnabled(user.getCompanyId()) && msg.indexOf(passwordHistory = PrefsPropsUtil.getString(user.getCompanyId(), "ldap.error.password.history")) != -1) {
                throw new UserPasswordException(1);
            }
            throw new UserPasswordException(3);
        }
        if (!silentUpdate) {
            user.setPasswordModified(false);
            this.passwordTrackerLocalService.trackPassword(userId, oldEncPwd);
        }
        return user;
    }

    public User updatePasswordManually(long userId, String password, boolean passwordEncrypted, boolean passwordReset, Date passwordModifiedDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPassword(password);
        user.setPasswordEncrypted(passwordEncrypted);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(passwordModifiedDate);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updatePasswordReset(long userId, boolean passwordReset) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPasswordReset(passwordReset);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updatePortrait(long userId, byte[] bytes) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long imageMaxSize = PrefsPropsUtil.getLong("users.image.max.size");
        if (imageMaxSize > 0L && (bytes == null || (long)bytes.length > imageMaxSize)) {
            throw new UserPortraitException();
        }
        long portraitId = user.getPortraitId();
        if (portraitId <= 0L) {
            portraitId = this.counterLocalService.increment();
            user.setPortraitId(portraitId);
            this.userPersistence.update((BaseModel)user, false);
        }
        try {
            ImageBag imageBag = ImageProcessorUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            renderedImage = ImageProcessorUtil.scale((RenderedImage)renderedImage, (int)PropsValues.USERS_IMAGE_MAX_HEIGHT, (int)PropsValues.USERS_IMAGE_MAX_WIDTH);
            String contentType = imageBag.getType();
            this.imageLocalService.updateImage(portraitId, ImageProcessorUtil.getBytes((RenderedImage)renderedImage, (String)contentType));
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public void updateReminderQuery(long userId, String question, String answer) throws PortalException, SystemException {
        this.validateReminderQuery(question, answer);
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setReminderQueryQuestion(question);
        user.setReminderQueryAnswer(answer);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updateScreenName(long userId, String screenName) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        screenName = this.getScreenName(screenName);
        this.validateScreenName(user.getCompanyId(), userId, screenName);
        user.setScreenName(screenName);
        this.userPersistence.update((BaseModel)user, false);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group, false);
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        String password = oldPassword;
        screenName = this.getScreenName(screenName);
        emailAddress = emailAddress.trim().toLowerCase();
        openId = openId.trim();
        aimSn = aimSn.trim().toLowerCase();
        facebookSn = facebookSn.trim().toLowerCase();
        icqSn = icqSn.trim().toLowerCase();
        jabberSn = jabberSn.trim().toLowerCase();
        msnSn = msnSn.trim().toLowerCase();
        mySpaceSn = mySpaceSn.trim().toLowerCase();
        skypeSn = skypeSn.trim().toLowerCase();
        twitterSn = twitterSn.trim().toLowerCase();
        ymSn = ymSn.trim().toLowerCase();
        Date now = new Date();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(user.getCompanyId(), userId);
        }
        this.validate(userId, screenName, emailAddress, firstName, middleName, lastName, smsSn);
        if (Validator.isNotNull((String)newPassword1) || Validator.isNotNull((String)newPassword2)) {
            user = this.updatePassword(userId, newPassword1, newPassword2, passwordReset);
            password = newPassword1;
        }
        user.setModifiedDate(now);
        if (user.getContactId() <= 0L) {
            user.setContactId(this.counterLocalService.increment());
        }
        user.setPasswordReset(passwordReset);
        if (Validator.isNotNull((String)reminderQueryQuestion) && Validator.isNotNull((String)reminderQueryAnswer)) {
            user.setReminderQueryQuestion(reminderQueryQuestion);
            user.setReminderQueryAnswer(reminderQueryAnswer);
        }
        user.setScreenName(screenName);
        this.setEmailAddress(user, password, firstName, middleName, lastName, emailAddress);
        user.setOpenId(openId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        user.setGreeting(greeting);
        user.setComments(comments);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        this.userPersistence.update((BaseModel)user, false);
        user.setExpandoBridgeAttributes(serviceContext);
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (PortalException)new ContactBirthdayException());
        long contactId = user.getContactId();
        Contact contact = this.contactPersistence.fetchByPrimaryKey(contactId);
        if (contact == null) {
            contact = this.contactPersistence.create(contactId);
            contact.setCompanyId(user.getCompanyId());
            contact.setUserName("");
            contact.setCreateDate(now);
            contact.setAccountId(company.getAccountId());
            contact.setParentContactId(0L);
        }
        contact.setModifiedDate(now);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setAimSn(aimSn);
        contact.setFacebookSn(facebookSn);
        contact.setIcqSn(icqSn);
        contact.setJabberSn(jabberSn);
        contact.setMsnSn(msnSn);
        contact.setMySpaceSn(mySpaceSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setYmSn(ymSn);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, false);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group, false);
        this.updateGroups(userId, groupIds);
        this.updateOrganizations(userId, organizationIds);
        if (roleIds != null) {
            roleIds = EnterpriseAdminUtil.addRequiredRoles(user, roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        if (userGroupRoles != null) {
            List previousUserGroupRoles = this.userGroupRolePersistence.findByUserId(userId);
            for (UserGroupRole userGroupRole : previousUserGroupRoles) {
                if (userGroupRoles.contains(userGroupRole)) {
                    userGroupRoles.remove(userGroupRole);
                    continue;
                }
                Role role = this.roleLocalService.getRole(userGroupRole.getRoleId());
                String name = role.getName();
                if (name.equals("Community Member") || name.equals("Organization Member")) continue;
                this.userGroupRoleLocalService.deleteUserGroupRole(userGroupRole);
            }
            for (UserGroupRole userGroupRole : userGroupRoles) {
                this.userGroupRoleLocalService.addUserGroupRole(userGroupRole);
            }
        }
        if (userGroupIds != null) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupIds, userId);
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.announcementsDeliveryLocalService.getUserDeliveries(user.getUserId());
        if (serviceContext != null) {
            this.updateTagsAsset(userId, user, serviceContext.getTagsEntries());
        }
        try {
            UserIndexer.updateUser(user);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + userId), (Throwable)se);
        }
        PermissionCacheUtil.clearCache();
        return user;
    }

    public void updateTagsAsset(long userId, User user, String[] tagsEntries) throws PortalException, SystemException {
        this.tagsAssetLocalService.updateAsset(userId, 0L, User.class.getName(), user.getUserId(), null, tagsEntries, true, null, null, null, null, null, user.getFullName(), null, null, null, 0, 0, null, false);
    }

    protected int authenticate(long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        login = login.trim().toLowerCase();
        long userId = GetterUtil.getLong((String)login);
        if (authType.equals("emailAddress")) {
            if (!Validator.isEmailAddress((String)login)) {
                throw new UserEmailAddressException();
            }
        } else if (authType.equals("screenName")) {
            if (Validator.isNull((String)login)) {
                throw new UserScreenNameException();
            }
        } else if (authType.equals("userId") && Validator.isNull((String)login)) {
            throw new UserIdException();
        }
        if (Validator.isNull((String)password)) {
            throw new UserPasswordException(3);
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("screenName")) {
            authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("userId")) {
            authResult = AuthPipeline.authenticateByUserId("auth.pipeline.pre", companyId, userId, password, headerMap, parameterMap);
        }
        User user = null;
        try {
            if (authType.equals("emailAddress")) {
                user = this.userPersistence.findByC_EA(companyId, login);
            } else if (authType.equals("screenName")) {
                user = this.userPersistence.findByC_SN(companyId, login);
            } else if (authType.equals("userId")) {
                user = this.userPersistence.findByC_U(companyId, GetterUtil.getLong((String)login));
            }
        }
        catch (NoSuchUserException nsue) {
            return 0;
        }
        if (user.isDefaultUser()) {
            _log.error((Object)"The default user should never be allowed to authenticate");
            return 0;
        }
        if (!user.isPasswordEncrypted()) {
            user.setPassword(PwdEncryptor.encrypt(user.getPassword()));
            user.setPasswordEncrypted(true);
            this.userPersistence.update((BaseModel)user, false);
        }
        this.checkLockout(user);
        this.checkPasswordExpired(user);
        if (authResult == 1 && PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) {
            String encPassword = PwdEncryptor.encrypt(password, user.getPassword());
            if (user.getPassword().equals(encPassword)) {
                authResult = 1;
            } else if (GetterUtil.getBoolean((String)PropsUtil.get("auth.mac.allow"))) {
                try {
                    MessageDigest digester = MessageDigest.getInstance(PropsUtil.get("auth.mac.algorithm"));
                    digester.update(login.getBytes("UTF8"));
                    String shardKey = PropsUtil.get("auth.mac.shared.key");
                    encPassword = Base64.encode((byte[])digester.digest(shardKey.getBytes("UTF8")));
                    if (password.equals(encPassword)) {
                        authResult = 1;
                    }
                    authResult = -1;
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new SystemException((Throwable)nsae);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new SystemException((Throwable)uee);
                }
            } else {
                authResult = -1;
            }
        }
        if (authResult == 1) {
            if (authType.equals("emailAddress")) {
                authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                authResult = AuthPipeline.authenticateByUserId("auth.pipeline.post", companyId, userId, password, headerMap, parameterMap);
            }
        }
        if (authResult == -1) {
            try {
                if (authType.equals("emailAddress")) {
                    AuthPipeline.onFailureByEmailAddress("auth.failure", companyId, login, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    AuthPipeline.onFailureByScreenName("auth.failure", companyId, login, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    AuthPipeline.onFailureByUserId("auth.failure", companyId, userId, headerMap, parameterMap);
                }
                if (!PortalLDAPUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
                    int maxFailures;
                    PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                    int failedLoginAttempts = user.getFailedLoginAttempts();
                    if (failedLoginAttempts >= (maxFailures = passwordPolicy.getMaxFailure()) && maxFailures != 0) {
                        if (authType.equals("emailAddress")) {
                            AuthPipeline.onMaxFailuresByEmailAddress("auth.max.failures", companyId, login, headerMap, parameterMap);
                        } else if (authType.equals("screenName")) {
                            AuthPipeline.onMaxFailuresByScreenName("auth.max.failures", companyId, login, headerMap, parameterMap);
                        } else if (authType.equals("userId")) {
                            AuthPipeline.onMaxFailuresByUserId("auth.max.failures", companyId, userId, headerMap, parameterMap);
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return authResult;
    }

    protected void doSendPassword(long companyId, String emailAddress, String remoteAddr, String remoteHost, String userAgent, String fromName, String fromAddress, String subject, String body) throws IOException, PortalException, SystemException {
        if (!PrefsPropsUtil.getBoolean(companyId, "company.security.send.password") || !PrefsPropsUtil.getBoolean(companyId, "admin.email.password.sent.enabled")) {
            return;
        }
        if (!Validator.isEmailAddress((String)(emailAddress = emailAddress.trim().toLowerCase()))) {
            throw new UserEmailAddressException();
        }
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        String newPassword = null;
        if (!PwdEncryptor.PASSWORDS_ENCRYPTION_ALGORITHM.equals("NONE")) {
            newPassword = PwdToolkitUtil.generate();
            boolean passwordReset = false;
            if (passwordPolicy.getChangeable() && passwordPolicy.getChangeRequired()) {
                passwordReset = true;
            }
            user.setPassword(PwdEncryptor.encrypt(newPassword));
            user.setPasswordUnencrypted(newPassword);
            user.setPasswordEncrypted(true);
            user.setPasswordReset(passwordReset);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            this.userPersistence.update((BaseModel)user, false);
            user.setPasswordModified(false);
        } else {
            newPassword = user.getPassword();
        }
        if (Validator.isNull((String)fromName)) {
            fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (Validator.isNull((String)subject)) {
            subject = PrefsPropsUtil.getContent(companyId, "admin.email.password.sent.subject");
        }
        if (Validator.isNull((String)body)) {
            body = PrefsPropsUtil.getContent(companyId, "admin.email.password.sent.body");
        }
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$REMOTE_ADDRESS$]", "[$REMOTE_HOST$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_AGENT$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, company.getVirtualHost(), remoteAddr, remoteHost, toAddress, toName, HtmlUtil.escape((String)userAgent), String.valueOf(user.getUserId()), newPassword, user.getScreenName()});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$REMOTE_ADDRESS$]", "[$REMOTE_HOST$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_AGENT$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, company.getVirtualHost(), remoteAddr, remoteHost, toAddress, toName, HtmlUtil.escape((String)userAgent), String.valueOf(user.getUserId()), newPassword, user.getScreenName()});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        this.mailService.sendEmail(message);
    }

    protected String getScreenName(String screenName) {
        return StringUtil.lowerCase((String)StringUtil.trim((String)screenName));
    }

    protected long[] getUserIds(List<User> users) {
        long[] userIds = new long[users.size()];
        for (int i = 0; i < users.size(); ++i) {
            User user = users.get(i);
            userIds[i] = user.getUserId();
        }
        return userIds;
    }

    protected void populateQuery(BooleanQuery contextQuery, BooleanQuery searchQuery, LinkedHashMap<String, Object> params, boolean andSearch) throws ParseException {
        if (params == null) {
            return;
        }
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((String)User.class.getName());
        Set attributeNames = SetUtil.fromEnumeration((Enumeration)expandoBridge.getAttributeNames());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            this.populateQuery(contextQuery, searchQuery, expandoBridge, attributeNames, key, value, andSearch);
        }
    }

    protected void populateQuery(BooleanQuery contextQuery, BooleanQuery searchQuery, ExpandoBridge expandoBridge, Set<String> attributeNames, String key, Object value, boolean andSearch) throws ParseException {
        if (key.equals("usersRoles")) {
            contextQuery.addRequiredTerm("roleIds", String.valueOf(value));
        } else if (key.equals("usersUserGroups")) {
            contextQuery.addRequiredTerm("userGroupIds", String.valueOf(value));
        } else if (key.equals("usersOrgs")) {
            if (value instanceof Long[]) {
                Long[] values = (Long[])value;
                BooleanQuery usersOrgsQuery = BooleanQueryFactoryUtil.create();
                Long[] arr$ = values;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    long organizationId = arr$[i$];
                    usersOrgsQuery.addTerm("organizationIds", organizationId);
                    usersOrgsQuery.addTerm("ancestorOrganizationIds", organizationId);
                }
                contextQuery.add((Query)usersOrgsQuery, BooleanClauseOccur.MUST);
            } else {
                contextQuery.addRequiredTerm("organizationIds", String.valueOf(value));
            }
        } else if (attributeNames.contains(key)) {
            int type;
            UnicodeProperties properties = expandoBridge.getAttributeProperties(key);
            if (GetterUtil.getBoolean((String)properties.getProperty("indexable")) && (type = expandoBridge.getAttributeType(key)) == 15 && Validator.isNotNull((String)((String)value))) {
                if (andSearch) {
                    searchQuery.addRequiredTerm(key, (String)value, true);
                } else {
                    searchQuery.addTerm(key, (String)value, true);
                }
            }
        } else if (Validator.isNotNull((String)key) && Validator.isNotNull((Object)value)) {
            if (andSearch) {
                searchQuery.addRequiredTerm(key, String.valueOf(value));
            } else {
                searchQuery.addTerm(key, String.valueOf(value));
            }
        }
    }

    protected void reIndexUsers(long companyId) throws SystemException {
        int count = this.userPersistence.countByCompanyId(companyId);
        int pages = count / 1000;
        for (int i = 0; i <= pages; ++i) {
            int start = i * 1000;
            int end = start + 1000;
            this.reIndexUsers(companyId, start, end);
        }
    }

    protected void reIndexUsers(long companyId, int start, int end) throws SystemException {
        List users = this.userPersistence.findByCompanyId(companyId, start, end);
        for (User user : users) {
            try {
                UserIndexer.updateUser(user);
            }
            catch (SearchException se) {
                _log.error((Object)("Reindexing " + user.getUserId()), (Throwable)se);
            }
        }
    }

    protected void sendEmail(User user, String password) throws IOException, PortalException, SystemException {
        if (!PrefsPropsUtil.getBoolean(user.getCompanyId(), "admin.email.user.added.enabled")) {
            return;
        }
        long companyId = user.getCompanyId();
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(companyId, "admin.email.user.added.subject");
        String body = PrefsPropsUtil.getContent(companyId, "admin.email.user.added.body");
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, company.getVirtualHost(), toAddress, toName, String.valueOf(user.getUserId()), password, user.getScreenName()});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, company.getVirtualHost(), toAddress, toName, String.valueOf(user.getUserId()), password, user.getScreenName()});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        this.mailService.sendEmail(message);
    }

    protected void setEmailAddress(User user, String password, String firstName, String middleName, String lastName, String emailAddress) {
        if (emailAddress.equalsIgnoreCase(user.getEmailAddress())) {
            return;
        }
        long userId = user.getUserId();
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress)) {
            this.mailService.addUser(user.getCompanyId(), userId, password, firstName, middleName, lastName, emailAddress);
        } else if (user.hasCompanyMx() && user.hasCompanyMx(emailAddress)) {
            this.mailService.updateEmailAddress(user.getCompanyId(), userId, emailAddress);
        } else if (user.hasCompanyMx() && !user.hasCompanyMx(emailAddress)) {
            this.mailService.deleteEmailAddress(user.getCompanyId(), userId);
        }
        user.setEmailAddress(emailAddress);
    }

    protected void validate(long userId, String screenName, String emailAddress, String firstName, String middleName, String lastName, String smsSn) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!user.getScreenName().equalsIgnoreCase(screenName)) {
            this.validateScreenName(user.getCompanyId(), userId, screenName);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress);
        if (!user.isDefaultUser()) {
            if (Validator.isNotNull((String)emailAddress) && !user.getEmailAddress().equalsIgnoreCase(emailAddress) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress) != null) {
                throw new DuplicateUserEmailAddressException();
            }
            this.validateFullName(user.getCompanyId(), firstName, middleName, lastName);
        }
        if (Validator.isNotNull((String)smsSn) && !Validator.isEmailAddress((String)smsSn)) {
            throw new UserSmsException();
        }
    }

    protected void validate(long companyId, long userId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, String firstName, String middleName, String lastName, long[] organizationIds) throws PortalException, SystemException {
        User user;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem()) {
            return;
        }
        if (!autoScreenName) {
            this.validateScreenName(companyId, userId, screenName);
        }
        if (!autoPassword) {
            PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
            PwdToolkitUtil.validate(companyId, 0L, password1, password2, passwordPolicy);
        }
        this.validateEmailAddress(companyId, emailAddress);
        if (Validator.isNotNull((String)emailAddress) && (user = this.userPersistence.fetchByC_EA(companyId, emailAddress)) != null) {
            throw new DuplicateUserEmailAddressException();
        }
        this.validateFullName(companyId, firstName, middleName, lastName);
    }

    protected void validateEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        if (Validator.isNull((String)emailAddress) && !PropsValues.USERS_EMAIL_ADDRESS_REQUIRED) {
            return;
        }
        if (!Validator.isEmailAddress((String)emailAddress) || emailAddress.startsWith("root@") || emailAddress.startsWith("postmaster@")) {
            throw new UserEmailAddressException();
        }
        String[] reservedEmailAddresses = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.email.addresses", "\n", PropsValues.ADMIN_RESERVED_EMAIL_ADDRESSES);
        for (int i = 0; i < reservedEmailAddresses.length; ++i) {
            if (!emailAddress.equalsIgnoreCase(reservedEmailAddresses[i])) continue;
            throw new ReservedUserEmailAddressException();
        }
    }

    protected void validateFullName(long companyId, String firstName, String middleName, String lastName) throws PortalException {
        if (Validator.isNull((String)firstName)) {
            throw new ContactFirstNameException();
        }
        if (Validator.isNull((String)lastName)) {
            throw new ContactLastNameException();
        }
        FullNameValidator fullNameValidator = FullNameValidatorFactory.getInstance();
        if (!fullNameValidator.validate(companyId, firstName, middleName, lastName)) {
            throw new ContactFullNameException();
        }
    }

    protected void validatePassword(long companyId, long userId, String password1, String password2) throws PortalException, SystemException {
        if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException(3);
        }
        if (!password1.equals(password2)) {
            throw new UserPasswordException(8);
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        PwdToolkitUtil.validate(companyId, userId, password1, password2, passwordPolicy);
    }

    protected void validateReminderQuery(String question, String answer) throws PortalException {
        if (!PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            return;
        }
        if (Validator.isNull((String)question)) {
            throw new UserReminderQueryException("Question cannot be null");
        }
        if (Validator.isNull((String)answer)) {
            throw new UserReminderQueryException("Answer cannot be null");
        }
    }

    protected void validateScreenName(long companyId, long userId, String screenName) throws PortalException, SystemException {
        if (Validator.isNull((String)screenName)) {
            throw new UserScreenNameException();
        }
        ScreenNameValidator screenNameValidator = ScreenNameValidatorFactory.getInstance();
        if (!screenNameValidator.validate(companyId, screenName)) {
            throw new UserScreenNameException();
        }
        if (Validator.isNumber((String)screenName) && !screenName.equals(String.valueOf(userId))) {
            throw new UserScreenNameException();
        }
        for (char c : screenName.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c) || c == '-' || c == '.' || c == '_') continue;
            throw new UserScreenNameException();
        }
        String[] anonymousNames = PrincipalBean.ANONYMOUS_NAMES;
        for (int i = 0; i < anonymousNames.length; ++i) {
            if (!screenName.equalsIgnoreCase(anonymousNames[i])) continue;
            throw new UserScreenNameException();
        }
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null) {
            throw new DuplicateUserScreenNameException();
        }
        String friendlyURL = "/" + screenName;
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null) {
            throw new DuplicateUserScreenNameException();
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new UserScreenNameException((Throwable)new GroupFriendlyURLException(exceptionType));
        }
        String[] reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", PropsValues.ADMIN_RESERVED_SCREEN_NAMES);
        for (int i = 0; i < reservedScreenNames.length; ++i) {
            if (!screenName.equalsIgnoreCase(reservedScreenNames[i])) continue;
            throw new ReservedUserScreenNameException();
        }
    }
}

