/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.Account;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.AccountLocalServiceUtil;
import com.liferay.portal.service.permission.AccountPermission;

public class AccountPermissionImpl
implements AccountPermission {
    public void check(PermissionChecker permissionChecker, long accountId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, accountId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, Account account, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, account, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long accountId, String actionId) throws PortalException, SystemException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        return this.contains(permissionChecker, account, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, Account account, String actionId) {
        long groupId = 0L;
        return permissionChecker.hasPermission(groupId, Account.class.getName(), account.getAccountId(), actionId);
    }
}

