/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermission;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import java.util.List;

public class GroupPermissionImpl
implements GroupPermission {
    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isOrganization()) {
            long organizationId = group.getClassPK();
            return OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)actionId);
        }
        if (group.isUser()) {
            long userId = group.getClassPK();
            List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
            for (Organization organization : organizations) {
                if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organization.getOrganizationId(), (String)"MANAGE_USERS")) continue;
                return true;
            }
        }
        return permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, actionId);
    }
}

