/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.permission.OrganizationPermission;

public class OrganizationPermissionImpl
implements OrganizationPermission {
    public void check(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, organizationId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, organization, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException, SystemException {
        if (organizationId > 0L) {
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            return this.contains(permissionChecker, organization, actionId);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException, SystemException {
        Group group = organization.getGroup();
        long groupId = group.getGroupId();
        if (this.contains(permissionChecker, groupId, organization, actionId)) {
            return true;
        }
        while (!organization.isRoot()) {
            Organization parentOrganization = organization.getParentOrganization();
            Group parentGroup = parentOrganization.getGroup();
            groupId = parentGroup.getGroupId();
            if (this.contains(permissionChecker, groupId, parentOrganization, "MANAGE_SUBORGANIZATIONS")) {
                return true;
            }
            organization = parentOrganization;
        }
        return false;
    }

    protected boolean contains(PermissionChecker permissionChecker, long groupId, Organization organization, String actionId) throws PortalException, SystemException {
        while (organization != null && organization.getOrganizationId() != 0L) {
            if (permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), actionId)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }
}

