/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import com.liferay.portal.service.persistence.AccountPersistence;
import com.liferay.portal.service.persistence.AddressPersistence;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.BrowserTrackerPersistence;
import com.liferay.portal.service.persistence.ClassNamePersistence;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.ContactPersistence;
import com.liferay.portal.service.persistence.CountryPersistence;
import com.liferay.portal.service.persistence.EmailAddressPersistence;
import com.liferay.portal.service.persistence.GroupPersistence;
import com.liferay.portal.service.persistence.ImagePersistence;
import com.liferay.portal.service.persistence.LayoutPersistence;
import com.liferay.portal.service.persistence.LayoutSetPersistence;
import com.liferay.portal.service.persistence.ListTypePersistence;
import com.liferay.portal.service.persistence.LockPersistence;
import com.liferay.portal.service.persistence.MembershipRequestPersistence;
import com.liferay.portal.service.persistence.OrgGroupPermissionPersistence;
import com.liferay.portal.service.persistence.OrgGroupRolePersistence;
import com.liferay.portal.service.persistence.OrgLaborPersistence;
import com.liferay.portal.service.persistence.OrganizationPersistence;
import com.liferay.portal.service.persistence.PasswordPolicyPersistence;
import com.liferay.portal.service.persistence.PasswordPolicyRelPersistence;
import com.liferay.portal.service.persistence.PasswordTrackerPersistence;
import com.liferay.portal.service.persistence.PermissionPersistence;
import com.liferay.portal.service.persistence.PhonePersistence;
import com.liferay.portal.service.persistence.PluginSettingPersistence;
import com.liferay.portal.service.persistence.PortletItemPersistence;
import com.liferay.portal.service.persistence.PortletPersistence;
import com.liferay.portal.service.persistence.PortletPreferencesPersistence;
import com.liferay.portal.service.persistence.RegionPersistence;
import com.liferay.portal.service.persistence.ReleasePersistence;
import com.liferay.portal.service.persistence.ResourceActionPersistence;
import com.liferay.portal.service.persistence.ResourceCodePersistence;
import com.liferay.portal.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.RolePersistence;
import com.liferay.portal.service.persistence.ServiceComponentPersistence;
import com.liferay.portal.service.persistence.ShardPersistence;
import com.liferay.portal.service.persistence.SubscriptionPersistence;
import com.liferay.portal.service.persistence.UserGroupGroupRolePersistence;
import com.liferay.portal.service.persistence.UserGroupPersistence;
import com.liferay.portal.service.persistence.UserGroupRolePersistence;
import com.liferay.portal.service.persistence.UserIdMapperPersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.UserTrackerPathPersistence;
import com.liferay.portal.service.persistence.UserTrackerPersistence;
import com.liferay.portal.service.persistence.WebDAVPropsPersistence;
import com.liferay.portal.service.persistence.WebsitePersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyPersistenceImpl
extends BasePersistenceImpl<Company>
implements CompanyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CompanyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = FINDER_CLASS_NAME_ENTITY + ".List";
    public static final FinderPath FINDER_PATH_FETCH_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByWebId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByWebId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_VIRTUALHOST = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByVirtualHost", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_VIRTUALHOST = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByVirtualHost", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByMx", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByMx", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByLogoId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByLogoId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findBySystem", new String[]{Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findBySystem", new String[]{Boolean.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countBySystem", new String[]{Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(name="com.liferay.portal.service.persistence.AccountPersistence")
    protected AccountPersistence accountPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.AddressPersistence")
    protected AddressPersistence addressPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.BrowserTrackerPersistence")
    protected BrowserTrackerPersistence browserTrackerPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ClassNamePersistence")
    protected ClassNamePersistence classNamePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.CompanyPersistence")
    protected CompanyPersistence companyPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ContactPersistence")
    protected ContactPersistence contactPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.CountryPersistence")
    protected CountryPersistence countryPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.EmailAddressPersistence")
    protected EmailAddressPersistence emailAddressPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.GroupPersistence")
    protected GroupPersistence groupPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ImagePersistence")
    protected ImagePersistence imagePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.LayoutPersistence")
    protected LayoutPersistence layoutPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.LayoutSetPersistence")
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ListTypePersistence")
    protected ListTypePersistence listTypePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.LockPersistence")
    protected LockPersistence lockPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.MembershipRequestPersistence")
    protected MembershipRequestPersistence membershipRequestPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.OrganizationPersistence")
    protected OrganizationPersistence organizationPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.OrgGroupPermissionPersistence")
    protected OrgGroupPermissionPersistence orgGroupPermissionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.OrgGroupRolePersistence")
    protected OrgGroupRolePersistence orgGroupRolePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.OrgLaborPersistence")
    protected OrgLaborPersistence orgLaborPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PasswordPolicyPersistence")
    protected PasswordPolicyPersistence passwordPolicyPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PasswordPolicyRelPersistence")
    protected PasswordPolicyRelPersistence passwordPolicyRelPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PasswordTrackerPersistence")
    protected PasswordTrackerPersistence passwordTrackerPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PermissionPersistence")
    protected PermissionPersistence permissionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PhonePersistence")
    protected PhonePersistence phonePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PluginSettingPersistence")
    protected PluginSettingPersistence pluginSettingPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PortletPersistence")
    protected PortletPersistence portletPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PortletItemPersistence")
    protected PortletItemPersistence portletItemPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.PortletPreferencesPersistence")
    protected PortletPreferencesPersistence portletPreferencesPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.RegionPersistence")
    protected RegionPersistence regionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ReleasePersistence")
    protected ReleasePersistence releasePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePersistence")
    protected ResourcePersistence resourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourceActionPersistence")
    protected ResourceActionPersistence resourceActionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourceCodePersistence")
    protected ResourceCodePersistence resourceCodePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePermissionPersistence")
    protected ResourcePermissionPersistence resourcePermissionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.RolePersistence")
    protected RolePersistence rolePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ServiceComponentPersistence")
    protected ServiceComponentPersistence serviceComponentPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ShardPersistence")
    protected ShardPersistence shardPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.SubscriptionPersistence")
    protected SubscriptionPersistence subscriptionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserPersistence")
    protected UserPersistence userPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserGroupPersistence")
    protected UserGroupPersistence userGroupPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserGroupGroupRolePersistence")
    protected UserGroupGroupRolePersistence userGroupGroupRolePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserGroupRolePersistence")
    protected UserGroupRolePersistence userGroupRolePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserIdMapperPersistence")
    protected UserIdMapperPersistence userIdMapperPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserTrackerPersistence")
    protected UserTrackerPersistence userTrackerPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserTrackerPathPersistence")
    protected UserTrackerPathPersistence userTrackerPathPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.WebDAVPropsPersistence")
    protected WebDAVPropsPersistence webDAVPropsPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.WebsitePersistence")
    protected WebsitePersistence websitePersistence;
    private static final String _SQL_SELECT_COMPANY = "SELECT company FROM Company company";
    private static final String _SQL_SELECT_COMPANY_WHERE = "SELECT company FROM Company company WHERE ";
    private static final String _SQL_COUNT_COMPANY = "SELECT COUNT(company) FROM Company company";
    private static final String _SQL_COUNT_COMPANY_WHERE = "SELECT COUNT(company) FROM Company company WHERE ";
    private static final String _FINDER_COLUMN_WEBID_WEBID_1 = "company.webId IS NULL";
    private static final String _FINDER_COLUMN_WEBID_WEBID_2 = "company.webId = ?";
    private static final String _FINDER_COLUMN_WEBID_WEBID_3 = "(company.webId IS NULL OR company.webId = ?)";
    private static final String _FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_1 = "company.virtualHost IS NULL";
    private static final String _FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_2 = "company.virtualHost = ?";
    private static final String _FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_3 = "(company.virtualHost IS NULL OR company.virtualHost = ?)";
    private static final String _FINDER_COLUMN_MX_MX_1 = "company.mx IS NULL";
    private static final String _FINDER_COLUMN_MX_MX_2 = "company.mx = ?";
    private static final String _FINDER_COLUMN_MX_MX_3 = "(company.mx IS NULL OR company.mx = ?)";
    private static final String _FINDER_COLUMN_LOGOID_LOGOID_2 = "company.logoId = ?";
    private static final String _FINDER_COLUMN_SYSTEM_SYSTEM_2 = "company.system = ?";
    private static final String _ORDER_BY_ENTITY_ALIAS = "company.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Company exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Company exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(CompanyPersistenceImpl.class);

    public void cacheResult(Company company) {
        EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{company.getWebId()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{company.getVirtualHost()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{company.getMx()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(company.getLogoId())}, (Object)company);
    }

    public void cacheResult(List<Company> companies) {
        for (Company company : companies) {
            if (EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(company);
        }
    }

    public void clearCache() {
        CacheRegistry.clear((String)CompanyImpl.class.getName());
        EntityCacheUtil.clearCache((String)CompanyImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public Company create(long companyId) {
        CompanyImpl company = new CompanyImpl();
        company.setNew(true);
        company.setPrimaryKey(companyId);
        return company;
    }

    public Company remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public Company remove(long companyId) throws NoSuchCompanyException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            Company company = (Company)session.get(CompanyImpl.class, (Serializable)new Long(companyId));
            if (company == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId));
                }
                throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId);
            }
            Company company2 = this.remove(company);
            return company2;
        }
        catch (NoSuchCompanyException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Company remove(Company company) throws SystemException {
        for (ModelListener listener : this.listeners) {
            listener.onBeforeRemove((Object)company);
        }
        company = this.removeImpl(company);
        for (ModelListener listener : this.listeners) {
            listener.onAfterRemove((Object)company);
        }
        return company;
    }

    protected Company removeImpl(Company company) throws SystemException {
        company = this.toUnwrappedModel(company);
        Session session = null;
        try {
            Object staleObject;
            session = this.openSession();
            if ((company.isCachedModel() || BatchSessionUtil.isEnabled()) && (staleObject = session.get(CompanyImpl.class, company.getPrimaryKeyObj())) != null) {
                session.evict(staleObject);
            }
            session.delete((Object)company);
            session.flush();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{companyModelImpl.getOriginalWebId()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{companyModelImpl.getOriginalVirtualHost()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{companyModelImpl.getOriginalMx()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(companyModelImpl.getOriginalLogoId())});
        EntityCacheUtil.removeResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
        return company;
    }

    public Company update(Company company) throws SystemException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Using the deprecated update(Company company) method. Use update(Company company, boolean merge) instead.");
        }
        return (Company)this.update((BaseModel)company, false);
    }

    public Company updateImpl(Company company, boolean merge) throws SystemException {
        company = this.toUnwrappedModel(company);
        boolean isNew = company.isNew();
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        Session session = null;
        try {
            session = this.openSession();
            BatchSessionUtil.update((Session)session, (BaseModel)company, (boolean)merge);
            company.setNew(false);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Object)company);
        if (!isNew && !Validator.equals((Object)company.getWebId(), (Object)companyModelImpl.getOriginalWebId())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{companyModelImpl.getOriginalWebId()});
        }
        if (isNew || !Validator.equals((Object)company.getWebId(), (Object)companyModelImpl.getOriginalWebId())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{company.getWebId()}, (Object)company);
        }
        if (!isNew && !Validator.equals((Object)company.getVirtualHost(), (Object)companyModelImpl.getOriginalVirtualHost())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{companyModelImpl.getOriginalVirtualHost()});
        }
        if (isNew || !Validator.equals((Object)company.getVirtualHost(), (Object)companyModelImpl.getOriginalVirtualHost())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{company.getVirtualHost()}, (Object)company);
        }
        if (!isNew && !Validator.equals((Object)company.getMx(), (Object)companyModelImpl.getOriginalMx())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{companyModelImpl.getOriginalMx()});
        }
        if (isNew || !Validator.equals((Object)company.getMx(), (Object)companyModelImpl.getOriginalMx())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{company.getMx()}, (Object)company);
        }
        if (!isNew && company.getLogoId() != companyModelImpl.getOriginalLogoId()) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(companyModelImpl.getOriginalLogoId())});
        }
        if (isNew || company.getLogoId() != companyModelImpl.getOriginalLogoId()) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(company.getLogoId())}, (Object)company);
        }
        return company;
    }

    protected Company toUnwrappedModel(Company company) {
        if (company instanceof CompanyImpl) {
            return company;
        }
        CompanyImpl companyImpl = new CompanyImpl();
        companyImpl.setNew(company.isNew());
        companyImpl.setPrimaryKey(company.getPrimaryKey());
        companyImpl.setCompanyId(company.getCompanyId());
        companyImpl.setAccountId(company.getAccountId());
        companyImpl.setWebId(company.getWebId());
        companyImpl.setKey(company.getKey());
        companyImpl.setVirtualHost(company.getVirtualHost());
        companyImpl.setMx(company.getMx());
        companyImpl.setHomeURL(company.getHomeURL());
        companyImpl.setLogoId(company.getLogoId());
        companyImpl.setSystem(company.isSystem());
        return companyImpl;
    }

    public Company findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public Company findByPrimaryKey(long companyId) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByPrimaryKey(companyId);
        if (company == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId));
            }
            throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId);
        }
        return company;
    }

    public Company fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public Company fetchByPrimaryKey(long companyId) throws SystemException {
        Company company = (Company)EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(companyId), (SessionFactory)this);
        if (company == null) {
            Session session = null;
            try {
                session = this.openSession();
                company = (Company)session.get(CompanyImpl.class, (Serializable)new Long(companyId));
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (company != null) {
                    this.cacheResult(company);
                }
                this.closeSession(session);
            }
        }
        return company;
    }

    public Company findByWebId(String webId) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByWebId(webId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("webId=");
            msg.append(webId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByWebId(String webId) throws SystemException {
        return this.fetchByWebId(webId, true);
    }

    public Company fetchByWebId(String webId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{webId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_SELECT_COMPANY_WHERE);
                if (webId == null) {
                    query.append(_FINDER_COLUMN_WEBID_WEBID_1);
                } else if (webId.equals("")) {
                    query.append(_FINDER_COLUMN_WEBID_WEBID_3);
                } else {
                    query.append(_FINDER_COLUMN_WEBID_WEBID_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (webId != null) {
                    qPos.add(webId);
                }
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getWebId() == null || !company.getWebId().equals(webId)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company findByVirtualHost(String virtualHost) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByVirtualHost(virtualHost);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("virtualHost=");
            msg.append(virtualHost);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByVirtualHost(String virtualHost) throws SystemException {
        return this.fetchByVirtualHost(virtualHost, true);
    }

    public Company fetchByVirtualHost(String virtualHost, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{virtualHost};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_SELECT_COMPANY_WHERE);
                if (virtualHost == null) {
                    query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_1);
                } else if (virtualHost.equals("")) {
                    query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_3);
                } else {
                    query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (virtualHost != null) {
                    qPos.add(virtualHost);
                }
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getVirtualHost() == null || !company.getVirtualHost().equals(virtualHost)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company findByMx(String mx) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByMx(mx);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mx=");
            msg.append(mx);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByMx(String mx) throws SystemException {
        return this.fetchByMx(mx, true);
    }

    public Company fetchByMx(String mx, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{mx};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_SELECT_COMPANY_WHERE);
                if (mx == null) {
                    query.append(_FINDER_COLUMN_MX_MX_1);
                } else if (mx.equals("")) {
                    query.append(_FINDER_COLUMN_MX_MX_3);
                } else {
                    query.append(_FINDER_COLUMN_MX_MX_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (mx != null) {
                    qPos.add(mx);
                }
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getMx() == null || !company.getMx().equals(mx)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company findByLogoId(long logoId) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByLogoId(logoId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("logoId=");
            msg.append(logoId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByLogoId(long logoId) throws SystemException {
        return this.fetchByLogoId(logoId, true);
    }

    public Company fetchByLogoId(long logoId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(logoId)};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_SELECT_COMPANY_WHERE);
                query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getLogoId() != logoId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public List<Company> findBySystem(boolean system) throws SystemException {
        Object[] finderArgs = new Object[]{system};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_SYSTEM, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_SELECT_COMPANY_WHERE);
                query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_SYSTEM, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_SYSTEM, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<Company> findBySystem(boolean system, int start, int end) throws SystemException {
        return this.findBySystem(system, start, end, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{system, String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_SYSTEM, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(2);
                query.append(_SQL_SELECT_COMPANY_WHERE);
                query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_SYSTEM, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_SYSTEM, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public Company findBySystem_First(boolean system, OrderByComparator obc) throws NoSuchCompanyException, SystemException {
        List<Company> list = this.findBySystem(system, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("system=");
            msg.append(system);
            msg.append("}");
            throw new NoSuchCompanyException(msg.toString());
        }
        return list.get(0);
    }

    public Company findBySystem_Last(boolean system, OrderByComparator obc) throws NoSuchCompanyException, SystemException {
        int count = this.countBySystem(system);
        List<Company> list = this.findBySystem(system, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("system=");
            msg.append(system);
            msg.append("}");
            throw new NoSuchCompanyException(msg.toString());
        }
        return list.get(0);
    }

    public Company[] findBySystem_PrevAndNext(long companyId, boolean system, OrderByComparator obc) throws NoSuchCompanyException, SystemException {
        Company company = this.findByPrimaryKey(companyId);
        int count = this.countBySystem(system);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(2);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(system);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)company);
            Company[] array = new CompanyImpl[]{(Company)objArray[0], (Company)objArray[1], (Company)objArray[2]};
            Company[] companyArray = array;
            return companyArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Company> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<Company> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<Company> findAll(int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(2 + obc.getOrderByFields().length * 3);
                    query.append(_SQL_SELECT_COMPANY);
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                    sql = query.toString();
                }
                sql = _SQL_SELECT_COMPANY;
                Query q = session.createQuery(sql);
                if (obc == null) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public void removeByWebId(String webId) throws NoSuchCompanyException, SystemException {
        Company company = this.findByWebId(webId);
        this.remove(company);
    }

    public void removeByVirtualHost(String virtualHost) throws NoSuchCompanyException, SystemException {
        Company company = this.findByVirtualHost(virtualHost);
        this.remove(company);
    }

    public void removeByMx(String mx) throws NoSuchCompanyException, SystemException {
        Company company = this.findByMx(mx);
        this.remove(company);
    }

    public void removeByLogoId(long logoId) throws NoSuchCompanyException, SystemException {
        Company company = this.findByLogoId(logoId);
        this.remove(company);
    }

    public void removeBySystem(boolean system) throws SystemException {
        for (Company company : this.findBySystem(system)) {
            this.remove(company);
        }
    }

    public void removeAll() throws SystemException {
        for (Company company : this.findAll()) {
            this.remove(company);
        }
    }

    public int countByWebId(String webId) throws SystemException {
        Object[] finderArgs = new Object[]{webId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_COMPANY_WHERE);
                if (webId == null) {
                    query.append(_FINDER_COLUMN_WEBID_WEBID_1);
                } else if (webId.equals("")) {
                    query.append(_FINDER_COLUMN_WEBID_WEBID_3);
                } else {
                    query.append(_FINDER_COLUMN_WEBID_WEBID_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (webId != null) {
                    qPos.add(webId);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByVirtualHost(String virtualHost) throws SystemException {
        Object[] finderArgs = new Object[]{virtualHost};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_VIRTUALHOST, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_COMPANY_WHERE);
                if (virtualHost == null) {
                    query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_1);
                } else if (virtualHost.equals("")) {
                    query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_3);
                } else {
                    query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (virtualHost != null) {
                    qPos.add(virtualHost);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_VIRTUALHOST, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByMx(String mx) throws SystemException {
        Object[] finderArgs = new Object[]{mx};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_COMPANY_WHERE);
                if (mx == null) {
                    query.append(_FINDER_COLUMN_MX_MX_1);
                } else if (mx.equals("")) {
                    query.append(_FINDER_COLUMN_MX_MX_3);
                } else {
                    query.append(_FINDER_COLUMN_MX_MX_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (mx != null) {
                    qPos.add(mx);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByLogoId(long logoId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(logoId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_COMPANY_WHERE);
                query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countBySystem(boolean system) throws SystemException {
        Object[] finderArgs = new Object[]{system};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_SYSTEM, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_COMPANY_WHERE);
                query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_SYSTEM, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMPANY);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portal.model.Company")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener)Class.forName(listenerClassName).newInstance());
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }
}

