/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.persistence.OrganizationFinder;
import com.liferay.portal.service.persistence.OrganizationUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationFinderImpl
extends BasePersistenceImpl<Organization>
implements OrganizationFinder {
    public static String COUNT_BY_ORGANIZATION_ID = OrganizationFinder.class.getName() + ".countByOrganizationId";
    public static String COUNT_BY_C_PO_N_S_C_Z_R_C = OrganizationFinder.class.getName() + ".countByC_PO_N_S_C_Z_R_C";
    public static String COUNT_BY_C_PO_N_L_S_C_Z_R_C = OrganizationFinder.class.getName() + ".countByC_PO_N_L_S_C_Z_R_C";
    public static String FIND_BY_C_PO_N_S_C_Z_R_C = OrganizationFinder.class.getName() + ".findByC_PO_N_S_C_Z_R_C";
    public static String FIND_BY_C_PO_N_L_S_C_Z_R_C = OrganizationFinder.class.getName() + ".findByC_PO_N_L_S_C_Z_R_C";
    public static String JOIN_BY_GROUPS_PERMISSIONS = OrganizationFinder.class.getName() + ".joinByGroupsPermissions";
    public static String JOIN_BY_ORGANIZATIONS_GROUPS = OrganizationFinder.class.getName() + ".joinByOrganizationsGroups";
    public static String JOIN_BY_ORGANIZATIONS_USER_GROUPS = OrganizationFinder.class.getName() + ".joinByOrganizationsUserGroups";
    public static String JOIN_BY_ORGANIZATIONS_PASSWORD_POLICIES = OrganizationFinder.class.getName() + ".joinByOrganizationsPasswordPolicies";
    public static String JOIN_BY_ORGANIZATIONS_ROLES = OrganizationFinder.class.getName() + ".joinByOrganizationsRoles";
    public static String JOIN_BY_ORGANIZATIONS_USERS = OrganizationFinder.class.getName() + ".joinByOrganizationsUsers";
    public static String JOIN_BY_ORG_GROUP_PERMISSION = OrganizationFinder.class.getName() + ".joinByOrgGroupPermission";
    public static String JOIN_BY_USERS_ORGS = OrganizationFinder.class.getName() + ".joinByUsersOrgs";
    protected static String COUNTRY_ID_SQL = "((Organization_.countryId = ?) OR (Address.countryId = ?)) [$AND_OR_CONNECTOR$]";
    protected static String REGION_ID_SQL = "((Organization_.regionId = ?) OR (Address.regionId = ?)) [$AND_OR_CONNECTOR$]";

    public int countByKeywords(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) throws SystemException {
        String[] names = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            streets = CustomSQLUtil.keywords((String)keywords);
            cities = CustomSQLUtil.keywords((String)keywords);
            zips = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator);
    }

    public int countByO_U(long organizationId, long userId) throws SystemException {
        LinkedHashMap<String, Object> params1 = new LinkedHashMap<String, Object>();
        params1.put("usersOrgs", userId);
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.put("organizationsUserGroups", userId);
        Session session = null;
        try {
            session = this.openSession();
            int count = this.countByOrganizationId(session, organizationId, params1);
            if (PropsValues.ORGANIZATIONS_USER_GROUP_MEMBERSHIP_ENABLED) {
                count += this.countByOrganizationId(session, organizationId, params2);
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        return this.countByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, new String[]{name}, type, new String[]{street}, new String[]{city}, new String[]{zip}, regionId, countryId, params, andOperator);
    }

    public int countByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names);
        streets = CustomSQLUtil.keywords((String[])streets);
        cities = CustomSQLUtil.keywords((String[])cities);
        zips = CustomSQLUtil.keywords((String[])zips);
        if (params != null) {
            Long resourceId = (Long)params.get("permissionsResourceId");
            Long groupId = (Long)params.get("permissionsGroupId");
            if (Validator.isNotNull((Long)groupId) && Validator.isNotNull((Long)resourceId)) {
                return this.countByPermissions(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, resourceId, groupId, andOperator);
            }
        }
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = null;
            sql = Validator.isNotNull((String)type) ? CustomSQLUtil.get((String)COUNT_BY_C_PO_N_L_S_C_Z_R_C) : CustomSQLUtil.get((String)COUNT_BY_C_PO_N_S_C_Z_R_C);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)parentOrganizationIdComparator);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            if (Validator.isNotNull((String)type)) {
                qPos.add(type);
            }
            qPos.add(names, 2);
            qPos.add(streets, 6);
            if (regionId != null) {
                qPos.add(regionId);
                qPos.add(regionId);
            }
            if (countryId != null) {
                qPos.add(countryId);
                qPos.add(countryId);
            }
            qPos.add(cities, 2);
            qPos.add(zips, 2);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Organization> findByKeywords(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String[] names = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            streets = CustomSQLUtil.keywords((String)keywords);
            cities = CustomSQLUtil.keywords((String)keywords);
            zips = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator, start, end, obc);
    }

    public List<Organization> findByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.findByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, new String[]{name}, type, new String[]{street}, new String[]{city}, new String[]{zip}, regionId, countryId, params, andOperator, start, end, obc);
    }

    public List<Organization> findByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names);
        streets = CustomSQLUtil.keywords((String[])streets);
        cities = CustomSQLUtil.keywords((String[])cities);
        zips = CustomSQLUtil.keywords((String[])zips);
        if (params != null) {
            Long resourceId = (Long)params.get("permissionsResourceId");
            Long groupId = (Long)params.get("permissionsGroupId");
            if (Validator.isNotNull((Long)groupId) && Validator.isNotNull((Long)resourceId)) {
                return this.findByPermissions(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, resourceId, groupId, andOperator, start, end, obc);
            }
        } else {
            params = new LinkedHashMap();
        }
        Long userId = null;
        if (PropsValues.ORGANIZATIONS_USER_GROUP_MEMBERSHIP_ENABLED) {
            userId = (Long)params.get("usersOrgs");
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.putAll(params1);
        if (userId != null) {
            params2.remove("usersOrgs");
            params2.put("organizationsUserGroups", userId);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (Validator.isNotNull((String)type)) {
            sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
        } else {
            sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
        }
        String sql = sb.toString();
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params1));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params1));
        sb = new StringBuilder();
        sb.append(sql);
        sb.append(")");
        if (Validator.isNotNull((Long)userId)) {
            sb.append(" UNION (");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
            }
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params2));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params2));
            sb = new StringBuilder();
            sb.append(sql);
            sb.append(")");
        }
        sql = sb.toString();
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
        sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)parentOrganizationIdComparator);
        if (regionId == null) {
            sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
        }
        if (countryId == null) {
            sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
        }
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("orgId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            if (Validator.isNotNull((String)type)) {
                qPos.add(type);
            }
            qPos.add(names, 2);
            qPos.add(streets, 6);
            if (regionId != null) {
                qPos.add(regionId);
                qPos.add(regionId);
            }
            if (countryId != null) {
                qPos.add(countryId);
                qPos.add(countryId);
            }
            qPos.add(cities, 2);
            qPos.add(zips, 2);
            if (Validator.isNotNull((Long)userId)) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (Validator.isNotNull((String)type)) {
                    qPos.add(type);
                }
                qPos.add(names, 2);
                qPos.add(streets, 6);
                if (regionId != null) {
                    qPos.add(regionId);
                    qPos.add(regionId);
                }
                if (countryId != null) {
                    qPos.add(countryId);
                    qPos.add(countryId);
                }
                qPos.add(cities, 2);
                qPos.add(zips, 2);
            }
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Long organizationId = (Long)itr.next();
                Organization organization = OrganizationUtil.findByPrimaryKey((long)organizationId);
                organizations.add(organization);
            }
            ArrayList<Organization> arrayList = organizations;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByOrganizationId(Session session, long organizationId, LinkedHashMap<String, Object> params) {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_ID);
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(organizationId);
        Iterator itr = q.list().iterator();
        if (itr.hasNext() && (count = (Long)itr.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected int countByPermissions(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, long resourceId, long groupId, boolean andOperator) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_S_C_Z_R_C));
            }
            String sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("groupsPermissions"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("groupsPermissions"));
            sb = new StringBuilder();
            sb.append(sql);
            sb.append(") UNION (");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_S_C_Z_R_C));
            }
            sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)parentOrganizationIdComparator);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sb = new StringBuilder();
            sb.append(sql);
            sb.append(")");
            sql = sb.toString();
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < 2; ++i) {
                qPos.add(resourceId);
                if (i == 1) {
                    qPos.add(groupId);
                }
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (Validator.isNotNull((String)type)) {
                    qPos.add(type);
                }
                qPos.add(names, 2);
                qPos.add(streets, 6);
                if (regionId != null) {
                    qPos.add(regionId);
                    qPos.add(regionId);
                }
                if (countryId != null) {
                    qPos.add(countryId);
                    qPos.add(countryId);
                }
                qPos.add(cities, 2);
                qPos.add(zips, 2);
            }
            int count = 0;
            for (Long l : q.list()) {
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Organization> findByPermissions(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, long resourceId, long groupId, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
            }
            String sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("groupsPermissions"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("groupsPermissions"));
            sb = new StringBuilder();
            sb.append(sql);
            sb.append(") UNION (");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
            }
            sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)parentOrganizationIdComparator);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sb = new StringBuilder();
            sb.append(sql);
            sb.append(") ");
            sql = sb.toString();
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("orgId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < 2; ++i) {
                qPos.add(resourceId);
                if (i == 1) {
                    qPos.add(groupId);
                }
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (Validator.isNotNull((String)type)) {
                    qPos.add(type);
                }
                qPos.add(names, 2);
                qPos.add(streets, 6);
                if (regionId != null) {
                    qPos.add(regionId);
                    qPos.add(regionId);
                }
                if (countryId != null) {
                    qPos.add(countryId);
                    qPos.add(countryId);
                }
                qPos.add(cities, 2);
                qPos.add(zips, 2);
            }
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Long organizationId = (Long)itr.next();
                Organization organization = OrganizationUtil.findByPrimaryKey((long)organizationId);
                organizations.add(organization);
            }
            ArrayList<Organization> arrayList = organizations;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("groupsPermissions")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_PERMISSIONS);
        } else if (key.equals("organizationsGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_GROUPS);
        } else if (key.equals("organizationsPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_PASSWORD_POLICIES);
        } else if (key.equals("organizationsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_ROLES);
        } else if (key.equals("organizationsUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_USER_GROUPS);
        } else if (key.equals("organizationsUsers")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_USERS);
        } else if (key.equals("orgGroupPermission")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORG_GROUP_PERMISSION);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        return this.getWhere(key, null);
    }

    protected String getWhere(String key, Object value) {
        StringBuilder sb;
        String join = "";
        if (key.equals("groupsPermissions")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_PERMISSIONS);
        } else if (key.equals("organizations")) {
            Long[] organizationIds = (Long[])value;
            if (organizationIds.length > 0) {
                sb = new StringBuilder();
                sb.append("WHERE (");
                for (int i = 0; i < organizationIds.length; ++i) {
                    sb.append("(Organization_.organizationId = ?) ");
                    if (i + 1 >= organizationIds.length) continue;
                    sb.append("OR ");
                }
                if (organizationIds.length == 0) {
                    sb.append("(Organization_.organizationId = -1) ");
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("organizationsGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_GROUPS);
        } else if (key.equals("organizationsPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_PASSWORD_POLICIES);
        } else if (key.equals("organizationsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_ROLES);
        } else if (key.equals("organizationsTree")) {
            Long[][] leftAndRightOrganizationIds = (Long[][])value;
            if (leftAndRightOrganizationIds.length > 0) {
                sb = new StringBuilder();
                sb.append("WHERE (");
                for (int i = 0; i < leftAndRightOrganizationIds.length; ++i) {
                    sb.append("(Organization_.leftOrganizationId BETWEEN ? AND ?) ");
                    if (i + 1 >= leftAndRightOrganizationIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("organizationsUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_USER_GROUPS);
        } else if (key.equals("organizationsUsers")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_USERS);
        } else if (key.equals("orgGroupPermission")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORG_GROUP_PERMISSION);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            if (pos != -1) {
                sb = new StringBuilder();
                sb.append(join.substring(pos + 5, join.length()));
                sb.append(" AND ");
                join = sb.toString();
            } else {
                join = "";
            }
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String valueString;
                Object value = entry.getValue();
                if (value instanceof Long) {
                    Long valueLong = (Long)value;
                    if (!Validator.isNotNull((Long)valueLong)) continue;
                    qPos.add(valueLong);
                    continue;
                }
                if (value instanceof Long[]) {
                    Long[] valueArray = (Long[])value;
                    for (int i = 0; i < valueArray.length; ++i) {
                        if (!Validator.isNotNull((Long)valueArray[i])) continue;
                        qPos.add(valueArray[i]);
                    }
                    continue;
                }
                if (value instanceof Long[][]) {
                    Long[][] valueDoubleArray;
                    Long[][] arr$ = valueDoubleArray = (Long[][])value;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Long[] valueArray;
                        for (Long valueLong : valueArray = arr$[i$]) {
                            qPos.add(valueLong);
                        }
                    }
                    continue;
                }
                if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
                qPos.add(valueString);
            }
        }
    }
}

