/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.PermissionImpl;
import com.liferay.portal.model.impl.PermissionModelImpl;
import com.liferay.portal.service.persistence.PermissionFinder;
import com.liferay.portal.service.persistence.PermissionPersistenceImpl;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionFinderImpl
extends BasePersistenceImpl<Permission>
implements PermissionFinder {
    public static String COUNT_BY_GROUPS_PERMISSIONS = PermissionFinder.class.getName() + ".countByGroupsPermissions";
    public static String COUNT_BY_GROUPS_ROLES = PermissionFinder.class.getName() + ".countByGroupsRoles";
    public static String COUNT_BY_ROLES_PERMISSIONS = PermissionFinder.class.getName() + ".countByRolesPermissions";
    public static String COUNT_BY_USER_GROUP_ROLE = PermissionFinder.class.getName() + ".countByUserGroupRole";
    public static String COUNT_BY_USERS_PERMISSIONS = PermissionFinder.class.getName() + ".countByUsersPermissions";
    public static String COUNT_BY_USERS_ROLES = PermissionFinder.class.getName() + ".countByUsersRoles";
    public static String FIND_BY_A_R = PermissionFinder.class.getName() + ".findByA_R";
    public static String FIND_BY_G_R = PermissionFinder.class.getName() + ".findByG_R";
    public static String FIND_BY_R_R = PermissionFinder.class.getName() + ".findByR_R";
    public static String FIND_BY_U_R = PermissionFinder.class.getName() + ".findByU_R";
    public static String FIND_BY_O_G_R = PermissionFinder.class.getName() + ".findByO_G_R";
    public static String FIND_BY_U_A_R = PermissionFinder.class.getName() + ".findByU_A_R";
    public static String FIND_BY_G_C_N_S_P = PermissionFinder.class.getName() + ".findByG_C_N_S_P";
    public static String FIND_BY_U_C_N_S_P = PermissionFinder.class.getName() + ".findByU_C_N_S_P";
    public static final FinderPath FINDER_PATH_COUNT_BY_ROLES_PERMISSIONS = new FinderPath(PermissionModelImpl.ENTITY_CACHE_ENABLED, PermissionModelImpl.FINDER_CACHE_ENABLED, "Roles_Permissions", "customCountByRolesPermissions", new String[]{List.class.getName(), List.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_A_R = new FinderPath(PermissionModelImpl.ENTITY_CACHE_ENABLED, PermissionModelImpl.FINDER_CACHE_ENABLED, PermissionPersistenceImpl.FINDER_CLASS_NAME_LIST, "customFindByA_R", new String[]{String.class.getName(), "[L" + Long.class.getName()});

    public boolean containsPermissions_2(List<Permission> permissions, long userId, List<Group> groups, long groupId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = null;
            StringBuilder sb = new StringBuilder();
            if (groups.size() > 0) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_GROUPS_ROLES));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$GROUP_IDS$]", (String)this.getGroupIds(groups, "Groups_Roles"));
                sb = new StringBuilder();
                sb.append(sql);
                sb.append("UNION ALL (");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_GROUPS_PERMISSIONS));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Groups_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$GROUP_IDS$]", (String)this.getGroupIds(groups, "Groups_Permissions"));
                sb = new StringBuilder();
                sb.append(sql);
                sb.append("UNION ALL ");
            }
            sb.append("(");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USERS_ROLES));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            sb = new StringBuilder();
            sb.append(sql);
            sb.append("UNION ALL (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER_GROUP_ROLE));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            sb = new StringBuilder();
            sb.append(sql);
            sb.append("UNION ALL (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USERS_PERMISSIONS));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Users_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (groups.size() > 0) {
                this.setPermissionIds(qPos, permissions);
                this.setGroupIds(qPos, groups);
                this.setPermissionIds(qPos, permissions);
                this.setGroupIds(qPos, groups);
            }
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            qPos.add(groupId);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            for (Long count : q.list()) {
                if (count == null || count.intValue() <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean containsPermissions_4(List<Permission> permissions, long userId, List<Group> groups, List<Role> roles) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = null;
            StringBuilder sb = new StringBuilder();
            if (groups.size() > 0) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_GROUPS_PERMISSIONS));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Groups_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$GROUP_IDS$]", (String)this.getGroupIds(groups, "Groups_Permissions"));
                sb = new StringBuilder();
                sb.append(sql);
                sb.append("UNION ALL ");
            }
            if (roles.size() > 0) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_ROLES_PERMISSIONS));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$ROLE_IDS$]", (String)this.getRoleIds(roles, "Roles_Permissions"));
                sb = new StringBuilder();
                sb.append(sql);
                sb.append("UNION ALL ");
            }
            sb.append("(");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USERS_PERMISSIONS));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Users_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (groups.size() > 0) {
                this.setPermissionIds(qPos, permissions);
                this.setGroupIds(qPos, groups);
            }
            if (roles.size() > 0) {
                this.setPermissionIds(qPos, permissions);
                this.setRoleIds(qPos, roles);
            }
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            for (Long count : q.list()) {
                if (count == null || count.intValue() <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByGroupsPermissions(List<Permission> permissions, List<Group> groups) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_GROUPS_PERMISSIONS);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Groups_Permissions"));
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_IDS$]", (String)this.getGroupIds(groups, "Groups_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            this.setGroupIds(qPos, groups);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByGroupsRoles(List<Permission> permissions, List<Group> groups) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_GROUPS_ROLES);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_IDS$]", (String)this.getGroupIds(groups, "Groups_Roles"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            this.setGroupIds(qPos, groups);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByRolesPermissions(List<Permission> permissions, List<Role> roles) throws SystemException {
        Object[] finderArgs = new Object[]{ListUtil.toString(permissions, (String)"permissionId"), ListUtil.toString(roles, (String)"roleId")};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_ROLES_PERMISSIONS, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                String sql = CustomSQLUtil.get((String)COUNT_BY_ROLES_PERMISSIONS);
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$ROLE_IDS$]", (String)this.getRoleIds(roles, "Roles_Permissions"));
                SQLQuery q = session.createSQLQuery(sql);
                q.addScalar("COUNT_VALUE", Type.LONG);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                this.setPermissionIds(qPos, permissions);
                this.setRoleIds(qPos, roles);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_ROLES_PERMISSIONS, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByUserGroupRole(List<Permission> permissions, long userId, long groupId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USER_GROUP_ROLE);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByUsersPermissions(List<Permission> permissions, long userId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USERS_PERMISSIONS);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Users_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByUsersRoles(List<Permission> permissions, long userId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USERS_ROLES);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_IDS$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByA_R(String actionId, long[] resourceIds) throws SystemException {
        Object[] finderArgs = new Object[]{actionId, StringUtil.merge((Object[])ArrayUtil.toArray((long[])resourceIds))};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                String sql = CustomSQLUtil.get((String)FIND_BY_A_R);
                sql = StringUtil.replace((String)sql, (String)"[$RESOURCE_IDS$]", (String)this.getResourceIds(resourceIds));
                SQLQuery q = session.createSQLQuery(sql);
                q.addEntity("Permission_", PermissionImpl.class);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(actionId);
                this.setResourceIds(qPos, resourceIds);
                list = q.list();
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            finally {
                if (list == null) {
                    list = new ArrayList();
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, list);
                this.closeSession(session);
            }
        }
        return list;
    }

    public List<Permission> findByG_R(long groupId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(resourceId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByR_R(long roleId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(roleId);
            qPos.add(resourceId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByU_R(long userId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(resourceId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByO_G_R(long organizationId, long groupId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_O_G_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(organizationId);
            qPos.add(groupId);
            qPos.add(resourceId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByU_A_R(long userId, String[] actionIds, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_R);
            sql = StringUtil.replace((String)sql, (String)"[$ACTION_IDS$]", (String)this.getActionIds(actionIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(resourceId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByG_C_N_S_P(long groupId, long companyId, String name, int scope, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_C_N_S_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByU_C_N_S_P(long userId, long companyId, String name, int scope, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_C_N_S_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getActionIds(String[] actionIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < actionIds.length; ++i) {
            sb.append("Permission_.actionId = ?");
            if (i + 1 >= actionIds.length) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected String getGroupIds(List<Group> groups, String table) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groups.size(); ++i) {
            sb.append(table);
            sb.append(".groupId = ?");
            if (i + 1 >= groups.size()) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected String getPermissionIds(List<Permission> permissions, String table) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < permissions.size(); ++i) {
            sb.append(table);
            sb.append(".permissionId = ?");
            if (i + 1 >= permissions.size()) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected String getResourceIds(long[] resourceIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < resourceIds.length; ++i) {
            sb.append("resourceId = ?");
            if (i + 1 >= resourceIds.length) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected String getRoleIds(List<Role> roles, String table) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < roles.size(); ++i) {
            sb.append(table);
            sb.append(".roleId = ?");
            if (i + 1 >= roles.size()) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected void setGroupIds(QueryPos qPos, List<Group> groups) {
        for (Group group : groups) {
            qPos.add(group.getGroupId());
        }
    }

    protected void setPermissionIds(QueryPos qPos, List<Permission> permissions) {
        for (Permission permission : permissions) {
            qPos.add(permission.getPermissionId());
        }
    }

    protected void setResourceIds(QueryPos qPos, long[] resourceIds) {
        for (long resourceId : resourceIds) {
            qPos.add(resourceId);
        }
    }

    protected void setRoleIds(QueryPos qPos, List<Role> roles) {
        for (Role role : roles) {
            qPos.add(role.getRoleId());
        }
    }
}

