/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.RoleImpl;
import com.liferay.portal.service.persistence.RoleFinder;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleFinderImpl
extends BasePersistenceImpl<Role>
implements RoleFinder {
    public static String COUNT_BY_COMMUNITY = RoleFinder.class.getName() + ".countByCommunity";
    public static String COUNT_BY_ORGANIZATION = RoleFinder.class.getName() + ".countByOrganization";
    public static String COUNT_BY_ORGANIZATION_COMMUNITY = RoleFinder.class.getName() + ".countByOrganizationCommunity";
    public static String COUNT_BY_USER = RoleFinder.class.getName() + ".countByUser";
    public static String COUNT_BY_USER_GROUP = RoleFinder.class.getName() + ".countByUserGroup";
    public static String COUNT_BY_USER_GROUP_COMMUNITY = RoleFinder.class.getName() + ".countByUserGroupCommunity";
    public static String COUNT_BY_U_G_R = RoleFinder.class.getName() + ".countByU_G_R";
    public static String COUNT_BY_C_N_D_T = RoleFinder.class.getName() + ".countByC_N_D_T";
    public static String FIND_BY_SYSTEM = RoleFinder.class.getName() + ".findBySystem";
    public static String FIND_BY_USER_GROUP_GROUP_ROLE = RoleFinder.class.getName() + ".findByUserGroupGroupRole";
    public static String FIND_BY_USER_GROUP_ROLE = RoleFinder.class.getName() + ".findByUserGroupRole";
    public static String FIND_BY_C_N = RoleFinder.class.getName() + ".findByC_N";
    public static String FIND_BY_U_G = RoleFinder.class.getName() + ".findByU_G";
    public static String FIND_BY_C_N_D_T = RoleFinder.class.getName() + ".findByC_N_D_T";
    public static String FIND_BY_C_N_S_P = RoleFinder.class.getName() + ".findByC_N_S_P";
    public static String JOIN_BY_ROLES_PERMISSIONS = RoleFinder.class.getName() + ".joinByRolesPermissions";
    public static String JOIN_BY_USERS_ROLES = RoleFinder.class.getName() + ".joinByUsersRoles";

    public int countByR_U(long roleId, long userId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_COMMUNITY));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_COMMUNITY));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER_GROUP));
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER_GROUP_COMMUNITY));
            sb.append(")");
            SQLQuery q = session.createSQLQuery(sb.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < 6; ++i) {
                qPos.add(roleId);
                qPos.add(userId);
            }
            int count = 0;
            for (Long l : q.list()) {
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByU_G_R(long userId, long groupId, long roleId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_U_G_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(roleId);
            qPos.add(groupId);
            qPos.add(userId);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_N_D_T(long companyId, String name, String description, Integer type, LinkedHashMap<String, Object> params) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_N_D_T);
            if (type == null) {
                sql = StringUtil.replace((String)sql, (String)"AND (Role_.type_ = ?)", (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            if (type != null) {
                qPos.add(type);
            }
            if ((itr = q.list().iterator()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findBySystem(long companyId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByUserGroupGroupRole(long userId, long groupId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_USER_GROUP_GROUP_ROLE);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(groupId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByUserGroupRole(long userId, long groupId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_USER_GROUP_ROLE);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(groupId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Role findByC_N(long companyId, String name) throws NoSuchRoleException, SystemException {
        name = StringUtil.lowerCase((String)name);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            List list = q.list();
            if (!list.isEmpty()) {
                Role role = (Role)list.get(0);
                return role;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("No Role exists with the key {companyId=");
        sb.append(companyId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchRoleException(sb.toString());
    }

    public List<Role> findByU_G(long userId, long groupId) throws SystemException {
        return this.findByU_G(userId, new long[]{groupId});
    }

    public List<Role> findByU_G(long userId, long[] groupIds) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_G);
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_IDS$]", (String)this.getGroupIds(groupIds, "Groups_Roles"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            this.setGroupIds(qPos, groupIds);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Role> findByU_G(long userId, List<Group> groups) throws SystemException {
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return this.findByU_G(userId, groupIds);
    }

    public List<Role> findByC_N_D_T(long companyId, String name, String description, Integer type, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N_D_T);
            if (type == null) {
                sql = StringUtil.replace((String)sql, (String)"AND (Role_.type_ = ?)", (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Role_", RoleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            if (type != null) {
                qPos.add(type);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Map<String, List<String>> findByC_N_S_P(long companyId, String name, int scope, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N_S_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("roleName", Type.STRING);
            q.addScalar("actionId", Type.STRING);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            HashMap<String, List<String>> roleMap = new HashMap<String, List<String>>();
            for (Object[] array : q.list()) {
                String roleName = (String)array[0];
                String actionId = (String)array[1];
                ArrayList<String> roleList = (ArrayList<String>)roleMap.get(roleName);
                if (roleList == null) {
                    roleList = new ArrayList<String>();
                }
                roleList.add(actionId);
                roleMap.put(roleName, roleList);
            }
            HashMap<String, List<String>> hashMap = roleMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getGroupIds(long[] groupIds, String table) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groupIds.length; ++i) {
            sb.append(table);
            sb.append(".groupId = ?");
            if (i + 1 >= groupIds.length) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected void setGroupIds(QueryPos qPos, long[] groupIds) {
        for (int i = 0; i < groupIds.length; ++i) {
            qPos.add(groupIds[i]);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("permissionsResourceId")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ROLES_PERMISSIONS);
        } else if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        String join = "";
        if (key.equals("permissionsResourceId")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ROLES_PERMISSIONS);
        } else if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            if (pos != -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(join.substring(pos + 5, join.length()));
                sb.append(" AND ");
                join = sb.toString();
            } else {
                join = "";
            }
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String valueString;
                Object value = entry.getValue();
                if (value instanceof Long) {
                    Long valueLong = (Long)value;
                    if (!Validator.isNotNull((Long)valueLong)) continue;
                    qPos.add(valueLong);
                    continue;
                }
                if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
                qPos.add(valueString);
            }
        }
    }
}

