/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.CustomSQLParam;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.service.persistence.UserFinder;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFinderImpl
extends BasePersistenceImpl<User>
implements UserFinder {
    public static String COUNT_BY_USER = UserFinder.class.getName() + ".countByUser";
    public static String COUNT_BY_C_FN_MN_LN_SN_EA_A = UserFinder.class.getName() + ".countByC_FN_MN_LN_SN_EA_A";
    public static String FIND_BY_NO_ANNOUNCEMENTS_DELIVERIES = UserFinder.class.getName() + ".findByNoAnnouncementsDeliveries";
    public static String FIND_BY_NO_CONTACTS = UserFinder.class.getName() + ".findByNoContacts";
    public static String FIND_BY_NO_GROUPS = UserFinder.class.getName() + ".findByNoGroups";
    public static String FIND_BY_C_FN_MN_LN_SN_EA_A = UserFinder.class.getName() + ".findByC_FN_MN_LN_SN_EA_A";
    public static String JOIN_BY_CONTACT_TWITTER_SN = UserFinder.class.getName() + ".joinByContactTwitterSN";
    public static String JOIN_BY_PERMISSION = UserFinder.class.getName() + ".joinByPermission";
    public static String JOIN_BY_USER_GROUP_ROLE = UserFinder.class.getName() + ".joinByUserGroupRole";
    public static String JOIN_BY_USERS_GROUPS = UserFinder.class.getName() + ".joinByUsersGroups";
    public static String JOIN_BY_USERS_ORGS = UserFinder.class.getName() + ".joinByUsersOrgs";
    public static String JOIN_BY_USERS_ORGS_TREE = UserFinder.class.getName() + ".joinByUsersOrgsTree";
    public static String JOIN_BY_USERS_PASSWORD_POLICIES = UserFinder.class.getName() + ".joinByUsersPasswordPolicies";
    public static String JOIN_BY_USERS_ROLES = UserFinder.class.getName() + ".joinByUsersRoles";
    public static String JOIN_BY_USERS_USER_GROUPS = UserFinder.class.getName() + ".joinByUsersUserGroups";
    public static String JOIN_BY_ANNOUNCEMENTS_DELIVERY_EMAIL_OR_SMS = UserFinder.class.getName() + ".joinByAnnouncementsDeliveryEmailOrSms";
    public static String JOIN_BY_SOCIAL_MUTUAL_RELATION = UserFinder.class.getName() + ".joinBySocialMutualRelation";
    public static String JOIN_BY_SOCIAL_MUTUAL_RELATION_TYPE = UserFinder.class.getName() + ".joinBySocialMutualRelationType";
    public static String JOIN_BY_SOCIAL_RELATION = UserFinder.class.getName() + ".joinBySocialRelation";
    public static String JOIN_BY_SOCIAL_RELATION_TYPE = UserFinder.class.getName() + ".joinBySocialRelationType";
    protected static String ACTIVE_SQL = "AND (User_.active_ = ?)";

    public int countByUser(long userId, LinkedHashMap<String, Object> params) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USER);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(userId);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByKeywords(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params) throws SystemException {
        String[] firstNames = null;
        String[] middleNames = null;
        String[] lastNames = null;
        String[] screenNames = null;
        String[] emailAddresses = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstNames = CustomSQLUtil.keywords((String)keywords);
            middleNames = CustomSQLUtil.keywords((String)keywords);
            lastNames = CustomSQLUtil.keywords((String)keywords);
            screenNames = CustomSQLUtil.keywords((String)keywords);
            emailAddresses = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_FN_MN_LN_SN_EA_A(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, active, params, andOperator);
    }

    public int countByC_FN_MN_LN_SN_EA_A(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        return this.countByC_FN_MN_LN_SN_EA_A(companyId, new String[]{firstName}, new String[]{middleName}, new String[]{lastName}, new String[]{screenName}, new String[]{emailAddress}, active, params, andOperator);
    }

    public int countByC_FN_MN_LN_SN_EA_A(long companyId, String[] firstNames, String[] middleNames, String[] lastNames, String[] screenNames, String[] emailAddresses, Boolean active, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        firstNames = CustomSQLUtil.keywords((String[])firstNames);
        middleNames = CustomSQLUtil.keywords((String[])middleNames);
        lastNames = CustomSQLUtil.keywords((String[])lastNames);
        screenNames = CustomSQLUtil.keywords((String[])screenNames);
        emailAddresses = CustomSQLUtil.keywords((String[])emailAddresses);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_FN_MN_LN_SN_EA_A);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.firstName)", (String)"LIKE", (boolean)false, (String[])firstNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.middleName)", (String)"LIKE", (boolean)false, (String[])middleNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.lastName)", (String)"LIKE", (boolean)false, (String[])lastNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.screenName)", (String)"LIKE", (boolean)false, (String[])screenNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.emailAddress)", (String)"LIKE", (boolean)true, (String[])emailAddresses);
            if (active == null) {
                sql = StringUtil.replace((String)sql, (String)ACTIVE_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(false);
            qPos.add(firstNames, 2);
            qPos.add(middleNames, 2);
            qPos.add(lastNames, 2);
            qPos.add(screenNames, 2);
            qPos.add(emailAddresses, 2);
            if (active != null) {
                qPos.add(active);
            }
            if ((itr = q.list().iterator()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByKeywords(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String[] firstNames = null;
        String[] middleNames = null;
        String[] lastNames = null;
        String[] screenNames = null;
        String[] emailAddresses = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstNames = CustomSQLUtil.keywords((String)keywords);
            middleNames = CustomSQLUtil.keywords((String)keywords);
            lastNames = CustomSQLUtil.keywords((String)keywords);
            screenNames = CustomSQLUtil.keywords((String)keywords);
            emailAddresses = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findByC_FN_MN_LN_SN_EA_A(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, active, params, andOperator, start, end, obc);
    }

    public List<User> findByNoAnnouncementsDeliveries(String type) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ANNOUNCEMENTS_DELIVERIES);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(type);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByNoContacts() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_CONTACTS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByNoGroups() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_GROUPS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByC_FN_MN_LN_SN_EA_A(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.findByC_FN_MN_LN_SN_EA_A(companyId, new String[]{firstName}, new String[]{middleName}, new String[]{lastName}, new String[]{screenName}, new String[]{emailAddress}, active, params, andOperator, start, end, obc);
    }

    public List<User> findByC_FN_MN_LN_SN_EA_A(long companyId, String[] firstNames, String[] middleNames, String[] lastNames, String[] screenNames, String[] emailAddresses, Boolean active, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        firstNames = CustomSQLUtil.keywords((String[])firstNames);
        middleNames = CustomSQLUtil.keywords((String[])middleNames);
        lastNames = CustomSQLUtil.keywords((String[])lastNames);
        screenNames = CustomSQLUtil.keywords((String[])screenNames);
        emailAddresses = CustomSQLUtil.keywords((String[])emailAddresses);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_FN_MN_LN_SN_EA_A);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.firstName)", (String)"LIKE", (boolean)false, (String[])firstNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.middleName)", (String)"LIKE", (boolean)false, (String[])middleNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.lastName)", (String)"LIKE", (boolean)false, (String[])lastNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.screenName)", (String)"LIKE", (boolean)false, (String[])screenNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.emailAddress)", (String)"LIKE", (boolean)true, (String[])emailAddresses);
            if (active == null) {
                sql = StringUtil.replace((String)sql, (String)ACTIVE_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(false);
            qPos.add(firstNames, 2);
            qPos.add(middleNames, 2);
            qPos.add(lastNames, 2);
            qPos.add(screenNames, 2);
            qPos.add(emailAddresses, 2);
            if (active != null) {
                qPos.add(active);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key, value));
        }
        return sb.toString();
    }

    protected String getJoin(String key, Object value) {
        int pos;
        String join = "";
        if (key.equals("contactTwitterSn")) {
            join = CustomSQLUtil.get((String)JOIN_BY_CONTACT_TWITTER_SN);
        } else if (key.equals("permission")) {
            join = CustomSQLUtil.get((String)JOIN_BY_PERMISSION);
        } else if (key.equals("userGroupRole")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE);
        } else if (key.equals("usersGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
        } else if (key.equals("usersOrgsTree")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS_TREE);
        } else if (key.equals("usersPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_PASSWORD_POLICIES);
        } else if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        } else if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("announcementsDeliveryEmailOrSms")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ANNOUNCEMENTS_DELIVERY_EMAIL_OR_SMS);
        } else if (key.equals("socialMutualRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION);
        } else if (key.equals("socialMutualRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION_TYPE);
        } else if (key.equals("socialRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION);
        } else if (key.equals("socialRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION_TYPE);
        } else if (value instanceof CustomSQLParam) {
            CustomSQLParam customSQLParam = (CustomSQLParam)value;
            join = customSQLParam.getSQL();
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key, Object value) {
        StringBuilder sb;
        String join = "";
        if (key.equals("contactTwitterSn")) {
            join = CustomSQLUtil.get((String)JOIN_BY_CONTACT_TWITTER_SN);
        } else if (key.equals("permission")) {
            join = CustomSQLUtil.get((String)JOIN_BY_PERMISSION);
        } else if (key.equals("userGroupRole")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE);
        } else if (key.equals("usersGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS);
        } else if (key.equals("usersOrgs")) {
            Long[] organizationIds;
            if (value instanceof Long) {
                join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
            } else if (value instanceof Long[] && (organizationIds = (Long[])value).length > 0) {
                sb = new StringBuilder();
                sb.append("WHERE (");
                for (int i = 0; i < organizationIds.length; ++i) {
                    sb.append("(Users_Orgs.organizationId = ?) ");
                    if (i + 1 >= organizationIds.length) continue;
                    sb.append("OR ");
                }
                if (organizationIds.length == 0) {
                    sb.append("(Users_Orgs.organizationId = -1) ");
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("usersOrgsTree")) {
            Long[][] leftAndRightOrganizationIds = (Long[][])value;
            sb = new StringBuilder();
            if (leftAndRightOrganizationIds.length > 0) {
                sb.append("WHERE (");
                for (int i = 0; i < leftAndRightOrganizationIds.length; ++i) {
                    sb.append("(Organization_.leftOrganizationId BETWEEN ? AND ?) ");
                    if (i + 1 >= leftAndRightOrganizationIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("usersPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_PASSWORD_POLICIES);
        } else if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        } else if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("announcementsDeliveryEmailOrSms")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ANNOUNCEMENTS_DELIVERY_EMAIL_OR_SMS);
        } else if (key.equals("socialMutualRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION);
        } else if (key.equals("socialMutualRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION_TYPE);
        } else if (key.equals("socialRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION);
        } else if (key.equals("socialRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION_TYPE);
        } else if (value instanceof CustomSQLParam) {
            CustomSQLParam customSQLParam = (CustomSQLParam)value;
            join = customSQLParam.getSQL();
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            if (pos != -1) {
                sb = new StringBuilder();
                sb.append(join.substring(pos + 5, join.length()));
                sb.append(" AND ");
                join = sb.toString();
            } else {
                join = "";
            }
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                int i;
                Object[] valueArray;
                Object value = entry.getValue();
                if (value instanceof Long) {
                    Long valueLong = (Long)value;
                    if (!Validator.isNotNull((Long)valueLong)) continue;
                    qPos.add(valueLong);
                    continue;
                }
                if (value instanceof Long[]) {
                    valueArray = (Long[])value;
                    for (i = 0; i < valueArray.length; ++i) {
                        if (!Validator.isNotNull((Long)valueArray[i])) continue;
                        qPos.add((Long)valueArray[i]);
                    }
                    continue;
                }
                if (value instanceof Long[][]) {
                    Long[][] valueDoubleArray;
                    Long[][] arr$ = valueDoubleArray = (Long[][])value;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Long[] valueArray2;
                        for (Long valueLong : valueArray2 = arr$[i$]) {
                            qPos.add(valueLong);
                        }
                    }
                    continue;
                }
                if (value instanceof String) {
                    String valueString = (String)value;
                    if (!Validator.isNotNull((String)valueString)) continue;
                    qPos.add(valueString);
                    continue;
                }
                if (value instanceof String[]) {
                    valueArray = (String[])value;
                    for (i = 0; i < valueArray.length; ++i) {
                        if (!Validator.isNotNull((String)valueArray[i])) continue;
                        qPos.add((String)valueArray[i]);
                    }
                    continue;
                }
                if (!(value instanceof CustomSQLParam)) continue;
                CustomSQLParam customSQLParam = (CustomSQLParam)value;
                customSQLParam.process(qPos);
            }
        }
    }
}

