/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.LastPath;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendlyURLServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private boolean _private;
    private boolean _user;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._private = GetterUtil.getBoolean((String)servletConfig.getInitParameter("private"));
        this._user = GetterUtil.getBoolean((String)servletConfig.getInitParameter("user"));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String redirect;
        String mainPath;
        ServletContext servletContext;
        block9: {
            servletContext = this.getServletContext();
            mainPath = "/c";
            String friendlyURLPath = null;
            friendlyURLPath = this._private ? (this._user ? PortalUtil.getPathFriendlyURLPrivateUser() : PortalUtil.getPathFriendlyURLPrivateGroup()) : PortalUtil.getPathFriendlyURLPublic();
            request.setAttribute("FRIENDLY_URL", (Object)(friendlyURLPath + request.getPathInfo()));
            redirect = mainPath;
            try {
                redirect = this.getRedirect(request, request.getPathInfo(), mainPath, request.getParameterMap());
                if (request.getAttribute("LAST_PATH") == null) {
                    LastPath lastPath = new LastPath(friendlyURLPath, request.getPathInfo(), request.getParameterMap());
                    request.setAttribute("LAST_PATH", (Object)lastPath);
                }
            }
            catch (NoSuchLayoutException nsle) {
                _log.warn((Throwable)nsle);
                PortalUtil.sendError((int)404, (Exception)((Object)nsle), (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Throwable)e);
            }
        }
        if (Validator.isNull((String)redirect)) {
            redirect = mainPath;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        if (redirect.startsWith("/")) {
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            response.sendRedirect(redirect);
        }
    }

    protected String getRedirect(HttpServletRequest request, String path, String mainPath, Map<String, String[]> params) throws Exception {
        Group group;
        int pos;
        String friendlyURL;
        block20: {
            if (Validator.isNull((String)path)) {
                return mainPath;
            }
            if (!path.startsWith("/")) {
                return mainPath;
            }
            friendlyURL = null;
            pos = path.indexOf("/", 1);
            if (pos != -1) {
                friendlyURL = path.substring(0, pos);
            } else if (path.length() > 1) {
                friendlyURL = path.substring(0, path.length());
            }
            if (Validator.isNull((String)friendlyURL)) {
                return mainPath;
            }
            long companyId = PortalInstances.getCompanyId(request);
            group = null;
            try {
                group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)friendlyURL);
            }
            catch (NoSuchGroupException nsge) {
                // empty catch block
            }
            if (group == null) {
                String screenName = friendlyURL.substring(1);
                if (this._user || !Validator.isNumber((String)screenName)) {
                    try {
                        User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                        group = user.getGroup();
                    }
                    catch (NoSuchUserException nsue) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("No user exists with friendly URL " + screenName));
                        }
                        break block20;
                    }
                }
                long groupId = GetterUtil.getLong((String)screenName);
                try {
                    group = GroupLocalServiceUtil.getGroup((long)groupId);
                }
                catch (NoSuchGroupException nsge) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("No group exists with friendly URL " + groupId + ". Try fetching by screen name instead."));
                    }
                    try {
                        User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                        group = user.getGroup();
                    }
                    catch (NoSuchUserException nsue) {
                        if (!_log.isWarnEnabled()) break block20;
                        _log.warn((Object)("No user or group exists with friendly URL " + groupId));
                    }
                }
            }
        }
        if (group == null) {
            return mainPath;
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != path.length()) {
            friendlyURL = path.substring(pos, path.length());
        }
        return PortalUtil.getLayoutActualURL((long)group.getGroupId(), (boolean)this._private, (String)mainPath, (String)friendlyURL, params);
    }
}

