/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.deploy.hot.PluginPackageHotDeployListener;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.events.StartupAction;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.job.Scheduler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.servlet.PortletSessionTracker;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalInitableUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.model.User;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.AbsoluteRedirectsResponse;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.struts.MultiMessageResources;
import com.liferay.portal.struts.PortletRequestProcessor;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portal.velocity.VelocityContextPool;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.model.impl.SocialActivityInterpreterImpl;
import com.liferay.portlet.social.model.impl.SocialRequestInterpreterImpl;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialRequestInterpreterLocalServiceUtil;
import com.liferay.util.servlet.DynamicServletRequest;
import com.liferay.util.servlet.EncryptedServletRequest;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainServlet
extends ActionServlet {
    private static final String _LIFERAY_PORTAL_REQUEST_HEADER = "Liferay-Portal";
    private static Log _log = LogFactoryUtil.getLog(MainServlet.class);

    public void destroy() {
        List portlets = PortletLocalServiceUtil.getPortlets();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy schedulers");
        }
        try {
            this.destroySchedulers(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy portlets");
        }
        try {
            this.destroyPortlets(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy companies");
        }
        try {
            this.destroyCompanies();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global shutdown events");
        }
        try {
            this.processGlobalShutdownEvents();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy");
        }
        this.callParentDestroy();
    }

    public void init() throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize");
        }
        this.callParentInit();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process startup events");
        }
        try {
            this.processStartupEvents();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            System.out.println("Stopping the server due to unexpected startup errors");
            System.exit(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize velocity");
        }
        try {
            this.initVelocity();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugin package");
        }
        PluginPackage pluginPackage = null;
        try {
            pluginPackage = this.initPluginPackage();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize portlets");
        }
        List<Portlet> portlets = null;
        try {
            portlets = this.initPortlets(pluginPackage);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize layout templates");
        }
        try {
            this.initLayoutTemplates(pluginPackage, portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize themes");
        }
        try {
            this.initThemes(pluginPackage, portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize indexers");
        }
        try {
            this.initIndexers(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize schedulers");
        }
        try {
            this.initSchedulers(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize poller processors");
        }
        try {
            this.initPollerProcessors(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize POP message listeners");
        }
        try {
            this.initPOPMessageListeners(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize social activity interpreters");
        }
        try {
            this.initSocialActivityInterpreters(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize social request interpreters");
        }
        try {
            this.initSocialRequestInterpreters(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize WebDAV storages");
        }
        try {
            this.initWebDAVStorages(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize web settings");
        }
        try {
            this.initWebSettings();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize extension environment");
        }
        try {
            this.initExt();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global startup events");
        }
        try {
            this.processGlobalStartupEvents();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize resource actions");
        }
        try {
            this.initResourceActions(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize resource codes");
        }
        try {
            this.initResourceCodes(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize companies");
        }
        try {
            this.initCompanies();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize message resources");
        }
        try {
            this.initMessageResources();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugins");
        }
        try {
            this.initPlugins();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected boolean processShutdownRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ShutdownUtil.isShutdown()) {
            return false;
        }
        response.setContentType("text/html; charset=UTF-8");
        String html = ContentUtil.get("com/liferay/portal/dependencies/shutdown.html");
        response.getOutputStream().print(html);
        return true;
    }

    protected boolean processMaintenanceRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!MaintenanceUtil.isMaintaining()) {
            return false;
        }
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/html/portal/maintenance.jsp");
        requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    protected HttpServletRequest protectRequest(HttpServletRequest request, String remoteUser) {
        return new ProtectedServletRequest(request, remoteUser);
    }

    protected HttpServletRequest encryptRequest(HttpServletRequest request, long companyId) {
        boolean encryptRequest = ParamUtil.getBoolean((HttpServletRequest)request, (String)"shuo");
        if (!encryptRequest) {
            return request;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            request = new EncryptedServletRequest(request, company.getKeyObj());
        }
        catch (Exception e) {
            // empty catch block
        }
        return request;
    }

    protected long getUserId(HttpServletRequest request) {
        return PortalUtil.getUserId((HttpServletRequest)request);
    }

    protected String getRemoteUser(HttpServletRequest request, long userId) {
        HttpSession session;
        String jRemoteUser;
        String remoteUser = request.getRemoteUser();
        if (!PropsValues.PORTAL_JAAS_ENABLE && (jRemoteUser = (String)(session = request.getSession()).getAttribute("j_remoteuser")) != null) {
            remoteUser = jRemoteUser;
            session.removeAttribute("j_remoteuser");
        }
        if (userId > 0L && remoteUser == null) {
            remoteUser = String.valueOf(userId);
        }
        return remoteUser;
    }

    protected void setPrincipalName(long userId, String remoteUser) {
        if (userId == 0L && remoteUser == null) {
            return;
        }
        String name = String.valueOf(userId);
        if (remoteUser != null) {
            name = remoteUser;
        }
        PrincipalThreadLocal.setName((String)name);
    }

    protected long getCompanyId(HttpServletRequest request) {
        long companyId = PortalInstances.getCompanyId(request);
        return companyId;
    }

    protected long loginUser(HttpServletRequest request, HttpServletResponse response, long userId, String remoteUser) throws PortalException, SystemException {
        if (userId > 0L || remoteUser == null) {
            return userId;
        }
        userId = GetterUtil.getLong((String)remoteUser);
        EventsProcessorUtil.process("login.events.pre", PropsValues.LOGIN_EVENTS_PRE, request, response);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        if (PropsValues.USERS_UPDATE_LAST_LOGIN) {
            UserLocalServiceUtil.updateLastLogin((long)userId, (String)request.getRemoteAddr());
        }
        HttpSession session = request.getSession();
        session.setAttribute("USER_ID", (Object)new Long(userId));
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)user.getLocale());
        EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, request, response);
        return userId;
    }

    protected void checkPortletSessionTracker(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session.getAttribute("PORTLET_SESSION_TRACKER") != null) {
            return;
        }
        session.setAttribute("PORTLET_SESSION_TRACKER", (Object)PortletSessionTracker.getInstance());
    }

    protected void checkPortletRequestProcessor(HttpServletRequest request) throws ServletException {
        ServletContext servletContext = this.getServletContext();
        PortletRequestProcessor portletReqProcessor = (PortletRequestProcessor)((Object)servletContext.getAttribute("PORTLET_STRUTS_PROCESSOR"));
        if (portletReqProcessor == null) {
            ModuleConfig moduleConfig = this.getModuleConfig(request);
            portletReqProcessor = PortletRequestProcessor.getInstance(this, moduleConfig);
            servletContext.setAttribute("PORTLET_STRUTS_PROCESSOR", (Object)portletReqProcessor);
        }
    }

    protected void checkTilesDefinitionsFactory() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY") != null) {
            return;
        }
        servletContext.setAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY", servletContext.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY"));
    }

    protected boolean processServicePre(HttpServletRequest request, HttpServletResponse response, long userId) throws IOException, ServletException {
        try {
            EventsProcessorUtil.process("servlet.service.events.pre", PropsValues.SERVLET_SERVICE_EVENTS_PRE, request, response);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchLayoutException) {
                this.sendError(404, cause, request, response);
                return true;
            }
            if (cause instanceof PrincipalException) {
                this.processServicePrePrincipalException(cause, userId, request, response);
                return true;
            }
            _log.error((Object)e, (Throwable)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            ServletContext servletContext = this.getServletContext();
            StrutsUtil.forward(PropsValues.SERVLET_SERVICE_EVENTS_PRE_ERROR_PAGE, servletContext, request, response);
            return true;
        }
        return false;
    }

    protected void processServicePost(HttpServletRequest request, HttpServletResponse response) {
        try {
            EventsProcessorUtil.process("servlet.service.events.post", PropsValues.SERVLET_SERVICE_EVENTS_POST, request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        response.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getReleaseInfo());
        CompanyThreadLocal.setCompanyId((long)0L);
        PrincipalThreadLocal.setName(null);
    }

    protected void checkServletContext(HttpServletRequest request) {
        ServletContext servletContext = this.getServletContext();
        request.setAttribute("CTX", (Object)servletContext);
    }

    protected boolean hasThemeDisplay(HttpServletRequest request) {
        return request.getAttribute("THEME_DISPLAY") != null;
    }

    protected boolean hasAbsoluteRedirect(HttpServletRequest request) {
        return request.getAttribute(AbsoluteRedirectsResponse.class.getName()) != null;
    }

    protected void setPortalPort(HttpServletRequest request) {
        PortalUtil.setPortalPort((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service request");
        }
        if (this.processShutdownRequest(request, response)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed shutdown request");
            }
            return;
        }
        if (this.processMaintenanceRequest(request, response)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed maintenance request");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        long companyId = this.getCompanyId(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set portal port");
        }
        this.setPortalPort(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check variables");
        }
        this.checkServletContext(request);
        this.checkPortletSessionTracker(request);
        this.checkPortletRequestProcessor(request);
        this.checkTilesDefinitionsFactory();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Encrypt request");
        }
        request = this.encryptRequest(request, companyId);
        long userId = this.getUserId(request);
        String remoteUser = this.getRemoteUser(request, userId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Protect request");
        }
        request = this.protectRequest(request, remoteUser);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set principal");
        }
        this.setPrincipalName(userId, remoteUser);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticate user id " + userId + " and remote user " + remoteUser));
            }
            userId = this.loginUser(request, response, userId, remoteUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticated user id " + userId));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service pre events");
        }
        if (this.processServicePre(request, response, userId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing service pre events has errors");
            }
            return;
        }
        if (this.hasAbsoluteRedirect(request)) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                _log.debug((Object)("Current URL " + currentURL + " has absolute redirect"));
            }
            return;
        }
        if (!this.hasThemeDisplay(request)) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                _log.debug((Object)("Current URL " + currentURL + " does not have a theme display"));
            }
            return;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Call parent service");
            }
            this.callParentService(request, response);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process service post events");
            }
            this.processServicePost(request, response);
        }
    }

    protected void callParentDestroy() {
        super.destroy();
    }

    protected void callParentInit() throws ServletException {
        super.init();
    }

    protected void callParentService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.service(request, response);
    }

    protected void checkWebSettings(String xml) throws DocumentException {
        Document doc = SAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        int timeout = PropsValues.SESSION_TIMEOUT;
        Element sessionConfig = root.element("session-config");
        if (sessionConfig != null) {
            String sessionTimeout = sessionConfig.elementText("session-timeout");
            timeout = GetterUtil.getInteger((String)sessionTimeout, (int)timeout);
        }
        PropsUtil.set("session.timeout", String.valueOf(timeout));
        PropsValues.SESSION_TIMEOUT = timeout;
        I18nServlet.setLanguageIds(root);
        I18nFilter.setLanguageIds(I18nServlet.getLanguageIds());
    }

    protected void destroyCompanies() throws Exception {
        long[] companyIds = PortalInstances.getCompanyIds();
        for (int i = 0; i < companyIds.length; ++i) {
            this.destroyCompany(companyIds[i]);
        }
    }

    protected void destroyCompany(long companyId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process shutdown events");
        }
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void destroyPortlets(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            PortletInstanceFactoryUtil.destroy((Portlet)portlet);
        }
    }

    protected void destroySchedulers(List<Portlet> portlets) throws Exception {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        for (String className : PropsValues.SCHEDULER_CLASSES) {
            Scheduler scheduler = (Scheduler)InstancePool.get((String)className, (boolean)false);
            if (scheduler == null) continue;
            scheduler.unschedule();
        }
        for (Portlet portlet : portlets) {
            Scheduler scheduler;
            String className = portlet.getSchedulerClass();
            if (!portlet.isActive() || Validator.isNull((String)className) || (scheduler = (Scheduler)InstancePool.get((String)className, (boolean)false)) == null) continue;
            scheduler.unschedule();
        }
    }

    protected synchronized RequestProcessor getRequestProcessor(ModuleConfig moduleConfig) throws ServletException {
        String key;
        ServletContext servletContext = this.getServletContext();
        RequestProcessor processor = (RequestProcessor)servletContext.getAttribute(key = "org.apache.struts.action.REQUEST_PROCESSOR" + moduleConfig.getPrefix());
        if (processor == null) {
            ControllerConfig controllerConfig = moduleConfig.getControllerConfig();
            String processorClass = controllerConfig.getProcessorClass();
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            try {
                processor = (RequestProcessor)classLoader.loadClass(processorClass).newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            processor.init((ActionServlet)this, moduleConfig);
            servletContext.setAttribute(key, (Object)processor);
        }
        return processor;
    }

    protected void initCompanies() throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] webIds = PortalInstances.getWebIds();
        for (int i = 0; i < webIds.length; ++i) {
            PortalInstances.initCompany(servletContext, webIds[i]);
        }
    }

    protected void initExt() throws Exception {
        ServletContext servletContext = this.getServletContext();
        ExtRegistry.registerPortal(servletContext);
    }

    protected void initIndexers(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            String indexerClass = portlet.getIndexerClass();
            if (!portlet.isActive() || Validator.isNull((String)indexerClass)) continue;
            Indexer indexer = (Indexer)InstancePool.get((String)indexerClass);
            for (String modelClassName : indexer.getClassNames()) {
                IndexerRegistryUtil.register((String)modelClassName, (Indexer)indexer);
            }
        }
    }

    protected void initLayoutTemplates(PluginPackage pluginPackage, List<Portlet> portlets) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates-ext.xml"))};
        LayoutTemplateLocalServiceUtil.init((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
    }

    protected void initMessageResources() throws Exception {
        ServletContext servletContext = this.getServletContext();
        MultiMessageResources messageResources = (MultiMessageResources)((Object)servletContext.getAttribute("org.apache.struts.action.MESSAGE"));
        LanguageResources.init((MessageResources)messageResources);
    }

    protected PluginPackage initPluginPackage() throws Exception {
        ServletContext servletContext = this.getServletContext();
        return PluginPackageHotDeployListener.readPluginPackage(servletContext);
    }

    protected void initPlugins() throws Exception {
        PortalInitableUtil.flushInitables();
        HotDeployUtil.flushPrematureEvents();
    }

    protected void initPollerProcessors(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            PollerProcessor pollerProcessor = portlet.getPollerProcessorInstance();
            if (!portlet.isActive() || pollerProcessor == null) continue;
            PollerProcessorUtil.addPollerProcessor(portlet.getPortletId(), pollerProcessor);
        }
    }

    protected void initPOPMessageListeners(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            MessageListener popMessageListener = portlet.getPopMessageListenerInstance();
            if (!portlet.isActive() || popMessageListener == null) continue;
            POPServerUtil.addListener(popMessageListener);
        }
    }

    protected void initPortletApp(Portlet portlet, ServletContext servletContext) throws PortletException {
        PortletApp portletApp = portlet.getPortletApp();
        PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        Set portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.create(portletFilter, portletContext);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected List<Portlet> initPortlets(PluginPackage pluginPackage) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-ext.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet-ext.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"))};
        PortletLocalServiceUtil.initEAR((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
        List portlets = PortletLocalServiceUtil.getPortlets();
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = (Portlet)portlets.get(i);
            if (i == 0) {
                this.initPortletApp(portlet, servletContext);
            }
            PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        }
        return portlets;
    }

    protected void initResourceActions(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            List<String> portletActions = ResourceActionsUtil.getPortletResourceActions(portlet.getPortletId());
            ResourceActionLocalServiceUtil.checkResourceActions((String)portlet.getPortletId(), portletActions);
            List<String> modelNames = ResourceActionsUtil.getPortletModelResources(portlet.getPortletId());
            for (String modelName : modelNames) {
                List<String> modelActions = ResourceActionsUtil.getModelResourceActions(modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, modelActions);
            }
        }
    }

    protected void initResourceCodes(List<Portlet> portlets) throws Exception {
        long[] companyIds = PortalInstances.getCompanyIds();
        for (Portlet portlet : portlets) {
            List<String> modelNames = ResourceActionsUtil.getPortletModelResources(portlet.getPortletId());
            for (long companyId : companyIds) {
                ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)portlet.getPortletId());
                for (String modelName : modelNames) {
                    ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)modelName);
                }
            }
        }
    }

    protected void initSchedulers(List<Portlet> portlets) throws Exception {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        for (String className : PropsValues.SCHEDULER_CLASSES) {
            Scheduler scheduler = (Scheduler)InstancePool.get((String)className);
            scheduler.schedule();
        }
        for (Portlet portlet : portlets) {
            String className = portlet.getSchedulerClass();
            if (!portlet.isActive() || Validator.isNull((String)className)) continue;
            Scheduler scheduler = (Scheduler)InstancePool.get((String)className);
            scheduler.schedule();
        }
    }

    protected void initSocialActivityInterpreters(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            SocialActivityInterpreter socialActivityInterpreter = portlet.getSocialActivityInterpreterInstance();
            if (!portlet.isActive() || socialActivityInterpreter == null) continue;
            socialActivityInterpreter = new SocialActivityInterpreterImpl(portlet.getPortletId(), socialActivityInterpreter);
            SocialActivityInterpreterLocalServiceUtil.addActivityInterpreter((SocialActivityInterpreter)socialActivityInterpreter);
        }
    }

    protected void initSocialRequestInterpreters(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            SocialRequestInterpreter socialRequestInterpreter = portlet.getSocialRequestInterpreterInstance();
            if (!portlet.isActive() || socialRequestInterpreter == null) continue;
            socialRequestInterpreter = new SocialRequestInterpreterImpl(portlet.getPortletId(), socialRequestInterpreter);
            SocialRequestInterpreterLocalServiceUtil.addRequestInterpreter((SocialRequestInterpreter)socialRequestInterpreter);
        }
    }

    protected void initThemes(PluginPackage pluginPackage, List<Portlet> portlets) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel-ext.xml"))};
        ThemeLocalServiceUtil.init((ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)pluginPackage);
    }

    protected void initVelocity() throws Exception {
        ServletContext servletContext = this.getServletContext();
        String contextPath = PortalUtil.getPathContext();
        VelocityContextPool.put(contextPath, servletContext);
    }

    protected void initWebDAVStorages(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            WebDAVStorage webDAVStorage = portlet.getWebDAVStorageInstance();
            if (!portlet.isActive() || webDAVStorage == null) continue;
            webDAVStorage.setToken(portlet.getWebDAVStorageToken());
            WebDAVUtil.addStorage((WebDAVStorage)webDAVStorage);
        }
    }

    protected void initWebSettings() throws Exception {
        ServletContext servletContext = this.getServletContext();
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"));
        this.checkWebSettings(xml);
    }

    protected void processGlobalShutdownEvents() throws Exception {
        EventsProcessorUtil.process("global.shutdown.events", PropsValues.GLOBAL_SHUTDOWN_EVENTS);
        super.destroy();
    }

    protected void processGlobalStartupEvents() throws Exception {
        EventsProcessorUtil.process("global.startup.events", PropsValues.GLOBAL_STARTUP_EVENTS);
    }

    protected void processServicePrePrincipalException(Throwable t, long userId, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (userId > 0L) {
            this.sendError(401, t, request, response);
            return;
        }
        String redirect = request.getContextPath() + "/c" + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid > 0L) {
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                if (layout.getGroup().isStagingGroup()) {
                    Group group = GroupLocalServiceUtil.getGroup((long)layout.getCompanyId(), (String)"Guest");
                    plid = group.getDefaultPublicPlid();
                } else if (layout.isPrivateLayout()) {
                    plid = LayoutLocalServiceUtil.getDefaultPlid((long)layout.getGroupId(), (boolean)false);
                }
                redirect = HttpUtil.addParameter((String)redirect, (String)"p_l_id", (long)plid);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        response.sendRedirect(redirect);
    }

    protected void processStartupEvents() throws Exception {
        StartupAction startupAction = new StartupAction();
        startupAction.run(null);
    }

    protected void sendError(int status, Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynamicServletRequest dynamicRequest = new DynamicServletRequest(request);
        dynamicRequest.setParameter("p_l_id", "");
        PortalUtil.sendError((int)status, (Exception)((Exception)t), (HttpServletRequest)dynamicRequest, (HttpServletResponse)response);
    }
}

