/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.util.ConcurrentHashSet;
import com.liferay.portal.servlet.SharedSessionAttributeCache;
import com.liferay.portal.util.PropsValues;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SharedSessionAttributeListener
implements HttpSessionAttributeListener,
HttpSessionListener {
    private Set<String> _sessionIds = new ConcurrentHashSet();

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (PropsValues.SESSION_DISABLED) {
            return;
        }
        HttpSession session = event.getSession();
        if (!this._sessionIds.contains(session.getId())) {
            return;
        }
        SharedSessionAttributeCache cache = SharedSessionAttributeCache.getInstance(session);
        String name = event.getName();
        for (String sharedName : PropsValues.SHARED_SESSION_ATTRIBUTES) {
            if (!name.startsWith(sharedName)) continue;
            cache.setAttribute(name, event.getValue());
            return;
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (PropsValues.SESSION_DISABLED) {
            return;
        }
        HttpSession session = event.getSession();
        if (!this._sessionIds.contains(session.getId())) {
            return;
        }
        SharedSessionAttributeCache cache = SharedSessionAttributeCache.getInstance(session);
        cache.removeAttribute(event.getName());
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (PropsValues.SESSION_DISABLED) {
            return;
        }
        HttpSession session = event.getSession();
        if (!this._sessionIds.contains(session.getId())) {
            return;
        }
        SharedSessionAttributeCache cache = SharedSessionAttributeCache.getInstance(session);
        if (cache.contains(event.getName())) {
            cache.setAttribute(event.getName(), event.getValue());
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (PropsValues.SESSION_DISABLED) {
            return;
        }
        HttpSession session = event.getSession();
        SharedSessionAttributeCache.getInstance(session);
        this._sessionIds.add(session.getId());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (PropsValues.SESSION_DISABLED) {
            return;
        }
        HttpSession session = event.getSession();
        this._sessionIds.remove(session.getId());
    }
}

