/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.audit;

import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuditFilter
extends BasePortalFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        auditRequestThreadLocal.setClientHost(request.getRemoteHost());
        auditRequestThreadLocal.setClientIP(request.getRemoteAddr());
        auditRequestThreadLocal.setQueryString(request.getQueryString());
        HttpSession session = request.getSession();
        Long userId = (Long)session.getAttribute("USER_ID");
        if (userId != null) {
            auditRequestThreadLocal.setRealUserId(userId.longValue());
        }
        auditRequestThreadLocal.setRequestURL(request.getRequestURL().toString());
        auditRequestThreadLocal.setServerName(request.getServerName());
        auditRequestThreadLocal.setServerPort(request.getServerPort());
        auditRequestThreadLocal.setSessionID(request.getSession().getId());
        try {
            this.processFilter(AuditFilter.class, request, response, filterChain);
        }
        finally {
            AuditRequestThreadLocal.removeAuditThreadLocal();
        }
    }
}

