/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.autologin;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AutoLoginFilter
extends BasePortalFilter {
    private static final String _PATH_CHAT_LATEST = "/-/chat/latest";
    private static Log _log = LogFactoryUtil.getLog(AutoLoginFilter.class);
    private static AutoLogin[] _autoLogins;

    public static void registerAutoLogin(AutoLogin autoLogin) {
        if (_autoLogins == null) {
            _log.error((Object)"AutoLoginFilter is not initialized yet");
            return;
        }
        List autoLogins = ListUtil.fromArray((Object[])_autoLogins);
        autoLogins.add(autoLogin);
        _autoLogins = autoLogins.toArray(new AutoLogin[autoLogins.size()]);
    }

    public static void unregisterAutoLogin(AutoLogin autoLogin) {
        if (_autoLogins == null) {
            _log.error((Object)"AutoLoginFilter is not initialized yet");
            return;
        }
        List autoLogins = ListUtil.fromArray((Object[])_autoLogins);
        if (autoLogins.remove(autoLogin)) {
            _autoLogins = autoLogins.toArray(new AutoLogin[autoLogins.size()]);
        }
    }

    public AutoLoginFilter() {
        ArrayList<AutoLogin> autoLogins = new ArrayList<AutoLogin>();
        for (String autoLoginClassName : PropsValues.AUTO_LOGIN_HOOKS) {
            AutoLogin autoLogin = (AutoLogin)InstancePool.get((String)autoLoginClassName);
            autoLogins.add(autoLogin);
        }
        _autoLogins = autoLogins.toArray(new AutoLogin[autoLogins.size()]);
    }

    protected String getLoginRemoteUser(HttpServletRequest request, HttpServletResponse response, HttpSession session, String[] credentials) throws Exception {
        if (credentials != null && credentials.length == 3) {
            String jUsername = credentials[0];
            String jPassword = credentials[1];
            boolean encPassword = GetterUtil.getBoolean((String)credentials[2]);
            if (Validator.isNotNull((String)jUsername) && Validator.isNotNull((String)jPassword)) {
                block9: {
                    try {
                        long userId = GetterUtil.getLong((String)jUsername);
                        if (userId > 0L) {
                            User user = UserLocalServiceUtil.getUserById((long)userId);
                            if (user.isLockout()) {
                                return null;
                            }
                            break block9;
                        }
                        return null;
                    }
                    catch (NoSuchUserException nsue) {
                        return null;
                    }
                }
                session.setAttribute("j_username", (Object)jUsername);
                if (encPassword) {
                    session.setAttribute("j_password", (Object)jPassword);
                } else {
                    session.setAttribute("j_password", (Object)PwdEncryptor.encrypt(jPassword));
                    session.setAttribute("USER_PASSWORD", (Object)jPassword);
                }
                if (PropsValues.PORTAL_JAAS_ENABLE) {
                    response.sendRedirect(PortalUtil.getPathMain() + "/portal/touch_protected");
                }
                return jUsername;
            }
        }
        return null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        HttpSession session = request.getSession();
        String host = PortalUtil.getHost((HttpServletRequest)request);
        if (PortalInstances.isAutoLoginIgnoreHost(host)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore host " + host));
            }
            this.processFilter(AutoLoginFilter.class, request, response, filterChain);
            return;
        }
        String contextPath = PortalUtil.getPathContext();
        String path = request.getRequestURI().toLowerCase();
        if (!contextPath.equals("/") && path.indexOf(contextPath) != -1) {
            path = path.substring(contextPath.length(), path.length());
        }
        if (PortalInstances.isAutoLoginIgnorePath(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore path " + path));
            }
            this.processFilter(AutoLoginFilter.class, request, response, filterChain);
            return;
        }
        String remoteUser = request.getRemoteUser();
        String jUserName = (String)session.getAttribute("j_username");
        if (remoteUser == null && jUserName == null) {
            for (AutoLogin autoLogin : _autoLogins) {
                try {
                    String[] credentials = autoLogin.login(request, response);
                    String redirect = (String)request.getAttribute("AUTO_LOGIN_REDIRECT");
                    if (Validator.isNotNull((String)redirect)) {
                        response.sendRedirect(redirect);
                        return;
                    }
                    String loginRemoteUser = this.getLoginRemoteUser(request, response, session, credentials);
                    if (loginRemoteUser == null) continue;
                    request = new ProtectedServletRequest(request, loginRemoteUser);
                    if (PropsValues.PORTAL_JAAS_ENABLE) {
                        return;
                    }
                    redirect = (String)request.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                    if (!Validator.isNotNull((String)redirect)) continue;
                    response.sendRedirect(redirect);
                    break;
                }
                catch (Exception e) {
                    String currentURL;
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    if ((currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request)).endsWith(_PATH_CHAT_LATEST)) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Current URL " + currentURL + " generates exception: " + e.getMessage()));
                        continue;
                    }
                    _log.error((Object)("Current URL " + currentURL + " generates exception: " + e.getMessage()));
                }
            }
        }
        this.processFilter(AutoLoginFilter.class, request, response, filterChain);
    }
}

