/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.util.servlet.filters.CacheResponse;
import com.liferay.util.servlet.filters.CacheResponseData;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagFilter
extends BasePortalFilter {
    private static final String _ETAG = "etag";

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        boolean etag = ParamUtil.getBoolean((HttpServletRequest)request, (String)_ETAG, (boolean)true);
        if (etag) {
            CacheResponse cacheResponse = new CacheResponse(response, "UTF-8");
            this.processFilter(ETagFilter.class, request, (HttpServletResponse)cacheResponse, filterChain);
            CacheResponseData cacheResponseData = new CacheResponseData(cacheResponse.getData(), cacheResponse.getContentType(), cacheResponse.getHeaders());
            if (!ETagUtil.processETag(request, response, cacheResponse.getData())) {
                CacheResponseUtil.write((HttpServletResponse)response, (CacheResponseData)cacheResponseData);
            }
        } else {
            this.processFilter(ETagFilter.class, request, response, filterChain);
        }
    }
}

