/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.servlet.filters.etag.ETagFilter;
import com.liferay.portal.util.PropsUtil;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagUtil {
    private static final boolean _ETAG_FILTER_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get(ETagFilter.class.getName()), (boolean)true);

    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, byte[] bytes) {
        if (!_ETAG_FILTER_ENABLED) {
            return false;
        }
        String eTag = Integer.toHexString(Arrays.hashCode(bytes));
        response.setHeader("ETag", eTag);
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (eTag.equals(ifNoneMatch)) {
            response.setStatus(304);
            response.setContentLength(0);
            return true;
        }
        return false;
    }

    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, String s) {
        return ETagUtil.processETag(request, response, s.getBytes());
    }
}

