/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.gzip.GZipResponse;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZipFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = GZipFilter.class.getName() + "SKIP_FILTER";
    private static final String _COMPRESS = "compress";
    private static Log _log = LogFactoryUtil.getLog(GZipFilter.class);
    private boolean _filterEnabled;

    public GZipFilter() {
        if (super.isFilterEnabled()) {
            this._filterEnabled = ServerDetector.isJBoss() || ServerDetector.isJetty() || ServerDetector.isJOnAS() || ServerDetector.isOC4J() || ServerDetector.isTomcat();
        }
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isCompress(HttpServletRequest request) {
        if (!ParamUtil.get((HttpServletRequest)request, (String)_COMPRESS, (boolean)true)) {
            return false;
        }
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle");
        return (!lifecycle.equals("1") || !LiferayWindowState.isExclusive((HttpServletRequest)request)) && !lifecycle.equals("2");
    }

    protected boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    protected boolean isInclude(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (this.isCompress(request) && !this.isInclude(request) && BrowserSnifferUtil.acceptsGzip((HttpServletRequest)request) && !this.isAlreadyFiltered(request)) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Compressing " + completeURL));
            }
            request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
            GZipResponse gZipResponse = new GZipResponse(response);
            this.processFilter(GZipFilter.class, request, (HttpServletResponse)gZipResponse, filterChain);
            gZipResponse.finishResponse();
        } else {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Not compressing " + completeURL));
            }
            this.processFilter(GZipFilter.class, request, response, filterChain);
        }
    }
}

