/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.servlet.filters.gzip.GZipStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZipResponse
extends HttpServletResponseWrapper {
    private HttpServletResponse _response;
    private ServletOutputStream _stream;
    private PrintWriter _writer;

    public GZipResponse(HttpServletResponse response) {
        super(response);
        this._response = response;
    }

    public void finishResponse() {
        try {
            if (this._writer != null) {
                this._writer.close();
            } else if (this._stream != null) {
                this._stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this._stream != null) {
            this._stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._writer != null) {
            throw new IllegalStateException();
        }
        if (this._stream == null) {
            this._stream = this._createOutputStream();
        }
        return this._stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer != null) {
            return this._writer;
        }
        if (this._stream != null) {
            throw new IllegalStateException();
        }
        this._stream = this._createOutputStream();
        this._writer = new PrintWriter(new OutputStreamWriter((OutputStream)this._stream, "UTF-8"));
        return this._writer;
    }

    private ServletOutputStream _createOutputStream() throws IOException {
        return new GZipStream(this._response);
    }
}

