/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZipStream
extends ServletOutputStream {
    private static final String _GZIP = "gzip";
    private static Log _log = LogFactoryUtil.getLog(GZipStream.class);
    private boolean _closed;
    private GZIPOutputStream _gzipOutputStream;
    private ServletOutputStream _outputStream;
    private HttpServletResponse _response;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;

    public GZipStream(HttpServletResponse response) throws IOException {
        this._response = response;
        this._outputStream = response.getOutputStream();
        this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        this._gzipOutputStream = new GZIPOutputStream((OutputStream)this._unsyncByteArrayOutputStream);
    }

    public void close() throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        this._gzipOutputStream.finish();
        byte[] bytes = this._unsyncByteArrayOutputStream.toByteArray();
        this._response.setContentLength(bytes.length);
        this._response.addHeader("Content-Encoding", _GZIP);
        this._outputStream.write(bytes);
        this._outputStream.flush();
        this._outputStream.close();
        this._closed = true;
    }

    public boolean closed() {
        return this._closed;
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        this._gzipOutputStream.flush();
    }

    public void reset() {
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        try {
            this._gzipOutputStream.write(b, off, len);
        }
        catch (IOException ioe) {
            _log.warn((Object)ioe.getMessage());
        }
    }

    public void write(int b) throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        this._gzipOutputStream.write((byte)b);
    }
}

