/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.language;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UnicodeLanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.util.servlet.filters.CacheResponse;
import com.liferay.util.servlet.filters.CacheResponseData;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LanguageFilter
extends BasePortalFilter {
    private static Pattern _pattern = Pattern.compile("Liferay\\.Language\\.get\\([\"']([^)]+)[\"']\\)");

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        CacheResponse cacheResponse = new CacheResponse(response, "UTF-8");
        this.processFilter(LanguageFilter.class, request, (HttpServletResponse)cacheResponse, filterChain);
        byte[] bytes = this.translateResponse(request, (HttpServletResponse)cacheResponse, cacheResponse.getData());
        CacheResponseData cacheResponseData = new CacheResponseData(bytes, cacheResponse.getContentType(), cacheResponse.getHeaders());
        CacheResponseUtil.write((HttpServletResponse)response, (CacheResponseData)cacheResponseData);
    }

    protected byte[] translateResponse(HttpServletRequest request, HttpServletResponse response, byte[] bytes) {
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        String content = new String(bytes);
        Matcher matcher = _pattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group(0);
            String key = matcher.group(1);
            StringBuffer sb = new StringBuffer();
            sb.append("'");
            sb.append(UnicodeLanguageUtil.get((Locale)locale, (String)key));
            sb.append("'");
            content = content.replace(match, sb.toString());
        }
        return content.getBytes();
    }
}

