/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.minifier;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.SystemProperties;
import com.liferay.util.servlet.ServletResponseUtil;
import com.liferay.util.servlet.filters.CacheResponse;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MinifierFilter
extends BasePortalFilter {
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _QUESTION_SEPARATOR = "_Q_";
    private static final String _TEMP_DIR = SystemProperties.get((String)"java.io.tmpdir") + "/liferay/minifier";
    private static Log _log = LogFactoryUtil.getLog(MinifierFilter.class);
    private static Pattern _pattern = Pattern.compile("^(\\.ie|\\.js\\.ie)([^}]*)}", 8);
    private ServletContext _servletContext;
    private String _servletContextName;
    private String _tempDir = _TEMP_DIR;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        this._servletContextName = GetterUtil.getString((String)this._servletContext.getServletContextName());
        if (Validator.isNull((String)this._servletContextName)) {
            this._tempDir = this._tempDir + "/portal";
        }
    }

    protected String aggregateCss(String dir, String content) throws IOException {
        StringBuilder sb = new StringBuilder(content.length());
        int pos = 0;
        while (true) {
            int x = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int y = content.indexOf(_CSS_IMPORT_END, x + _CSS_IMPORT_BEGIN.length());
            if (x == -1 || y == -1) break;
            sb.append(content.substring(pos, x));
            String importFile = content.substring(x + _CSS_IMPORT_BEGIN.length(), y);
            String importContent = FileUtil.read((String)(dir + "/" + importFile));
            String importFilePath = "";
            if (importFile.lastIndexOf("/") != -1) {
                importFilePath = "/" + importFile.substring(0, importFile.lastIndexOf("/") + 1);
            }
            importContent = this.aggregateCss(dir + importFilePath, importContent);
            int importDepth = StringUtil.count((String)importFile, (String)"/");
            String relativePath = "";
            for (int i = 0; i < importDepth; ++i) {
                relativePath = relativePath + "../";
            }
            importContent = StringUtil.replace((String)importContent, (String[])new String[]{"url('" + relativePath, "url(\"" + relativePath, "url(" + relativePath}, (String[])new String[]{"url('[$TEMP_RELATIVE_PATH$]", "url(\"[$TEMP_RELATIVE_PATH$]", "url([$TEMP_RELATIVE_PATH$]"});
            importContent = StringUtil.replace((String)importContent, (String)"[$TEMP_RELATIVE_PATH$]", (String)"");
            sb.append(importContent);
            pos = y + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos, content.length()));
        return sb.toString();
    }

    protected String getMinifiedBundleContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        if (Validator.isNull((String)minifierType) || Validator.isNull((String)minifierBundleId) || !ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)minifierBundleId)) {
            return null;
        }
        String minifierBundleDir = PropsUtil.get("javascript.bundle.dir", new Filter(minifierBundleId));
        String bundleDirRealPath = ServletContextUtil.getRealPath((ServletContext)this._servletContext, (String)minifierBundleDir);
        if (bundleDirRealPath == null) {
            return null;
        }
        String cacheFileName = this._tempDir + request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            cacheFileName = cacheFileName + _QUESTION_SEPARATOR + queryString;
        }
        String[] fileNames = PropsUtil.getArray(minifierBundleId);
        File cacheFile = new File(cacheFileName);
        if (cacheFile.exists()) {
            boolean staleCache = false;
            for (String fileName : fileNames) {
                File file = new File(bundleDirRealPath + "/" + fileName);
                if (file.lastModified() <= cacheFile.lastModified()) continue;
                staleCache = true;
                break;
            }
            if (!staleCache) {
                response.setContentType("text/javascript");
                return FileUtil.read((File)cacheFile);
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Minifying JavaScript bundle " + minifierBundleId));
        }
        StringBuilder sb = new StringBuilder();
        for (String fileName : fileNames) {
            String content = FileUtil.read((String)(bundleDirRealPath + "/" + fileName));
            sb.append(content);
            sb.append("\n");
        }
        String minifiedContent = this.minifyJavaScript(sb.toString());
        response.setContentType("text/javascript");
        FileUtil.write((File)cacheFile, (String)minifiedContent);
        return minifiedContent;
    }

    protected String getMinifiedContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String realPath;
        String requestURI;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        String minifierBundleDir = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleDir");
        if (Validator.isNull((String)minifierType) || Validator.isNotNull((String)minifierBundleId) || Validator.isNotNull((String)minifierBundleDir)) {
            return null;
        }
        String requestPath = requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (!contextPath.equals("/")) {
            requestPath = requestPath.substring(contextPath.length());
        }
        if ((realPath = ServletContextUtil.getRealPath((ServletContext)this._servletContext, (String)requestPath)) == null) {
            return null;
        }
        File file = new File(realPath = StringUtil.replace((String)realPath, (String)"\\", (String)"/"));
        if (!file.exists()) {
            return null;
        }
        String minifiedContent = null;
        String cacheCommonFileName = this._tempDir + requestURI;
        String queryString = request.getQueryString();
        if (queryString != null) {
            cacheCommonFileName = cacheCommonFileName + _QUESTION_SEPARATOR + queryString;
        }
        File cacheContentTypeFile = new File(cacheCommonFileName + "_E_CONTENT_TYPE");
        File cacheDataFile = new File(cacheCommonFileName + "_E_DATA");
        if (cacheDataFile.exists() && cacheDataFile.lastModified() >= file.lastModified()) {
            minifiedContent = FileUtil.read((File)cacheDataFile);
            if (cacheContentTypeFile.exists()) {
                String contentType = FileUtil.read((File)cacheContentTypeFile);
                response.setContentType(contentType);
            }
        } else {
            if (realPath.endsWith(_CSS_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying CSS " + file));
                }
                minifiedContent = this.minifyCss(request, file);
                response.setContentType("text/css");
                FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
            } else if (realPath.endsWith(_JAVASCRIPT_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying JavaScript " + file));
                }
                minifiedContent = this.minifyJavaScript(file);
                response.setContentType("text/javascript");
                FileUtil.write((File)cacheContentTypeFile, (String)"text/javascript");
            } else if (realPath.endsWith(_JSP_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying JSP " + file));
                }
                CacheResponse cacheResponse = new CacheResponse(response, "UTF-8");
                this.processFilter(MinifierFilter.class, request, (HttpServletResponse)cacheResponse, filterChain);
                CacheResponseUtil.addHeaders((HttpServletResponse)response, (Map)cacheResponse.getHeaders());
                response.setContentType(cacheResponse.getContentType());
                minifiedContent = new String(cacheResponse.getData(), "UTF-8");
                if (minifierType.equals("css")) {
                    minifiedContent = this.minifyCss(request, minifiedContent);
                } else if (minifierType.equals("js")) {
                    minifiedContent = this.minifyJavaScript(minifiedContent);
                }
                FileUtil.write((File)cacheContentTypeFile, (String)cacheResponse.getContentType());
            } else {
                return null;
            }
            FileUtil.write((File)cacheDataFile, (String)minifiedContent);
        }
        return minifiedContent;
    }

    protected String minifyCss(HttpServletRequest request, File file) throws IOException {
        String content = FileUtil.read((File)file);
        content = this.aggregateCss(file.getParent(), content);
        return this.minifyCss(request, content);
    }

    protected String minifyCss(HttpServletRequest request, String content) {
        String browserId = ParamUtil.getString((HttpServletRequest)request, (String)"browserId");
        if (!browserId.equals("ie")) {
            Matcher matcher = _pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        return MinifierUtil.minifyCss(content);
    }

    protected String minifyJavaScript(File file) throws IOException {
        String content = FileUtil.read((File)file);
        return this.minifyJavaScript(content);
    }

    protected String minifyJavaScript(String content) {
        return MinifierUtil.minifyJavaScript(content);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String minifiedContent = this.getMinifiedContent(request, response, filterChain);
        if (Validator.isNull((String)minifiedContent)) {
            minifiedContent = this.getMinifiedBundleContent(request, response);
        }
        if (Validator.isNull((String)minifiedContent)) {
            this.processFilter(MinifierFilter.class, request, response, filterChain);
        } else if (!ETagUtil.processETag(request, response, minifiedContent)) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)minifiedContent);
        }
    }
}

