/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SecureFilter
extends BasePortalFilter {
    private static final String _SERVER_IP = "SERVER_IP";
    private static final String _PORTAL_REALM = "Basic realm=\"PortalRealm\"";
    private static final String _AUTHENTICATED_USER = SecureFilter.class + "_AUTHENTICATED_USER";
    private static Log _log = LogFactoryUtil.getLog(SecureFilter.class);
    private boolean _basicAuthEnabled;
    private Set<String> _hostsAllowed = new HashSet<String>();
    private boolean _httpsRequired;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._basicAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("basic_auth"));
        String propertyPrefix = filterConfig.getInitParameter("portal_property_prefix");
        String[] hostsAllowedArray = null;
        if (Validator.isNull((String)propertyPrefix)) {
            hostsAllowedArray = StringUtil.split((String)filterConfig.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)filterConfig.getInitParameter("https.required"));
        } else {
            hostsAllowedArray = PropsUtil.getArray(propertyPrefix + "hosts.allowed");
            this._httpsRequired = GetterUtil.getBoolean((String)PropsUtil.get(propertyPrefix + "https.required"));
        }
        for (int i = 0; i < hostsAllowedArray.length; ++i) {
            this._hostsAllowed.add(hostsAllowedArray[i]);
        }
    }

    protected boolean isAccessAllowed(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String serverIp = PortalUtil.getComputerAddress();
        if (this._hostsAllowed.size() > 0 && !this._hostsAllowed.contains(remoteAddr)) {
            return serverIp.equals(remoteAddr) && this._hostsAllowed.contains(_SERVER_IP);
        }
        return true;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String remoteAddr = request.getRemoteAddr();
        if (this.isAccessAllowed(request)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Access denied for " + remoteAddr));
            }
            response.sendError(403, "Access denied for " + remoteAddr);
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug((Object)"https is required");
            } else {
                _log.debug((Object)"https is not required");
            }
        }
        if (this._httpsRequired && !request.isSecure()) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Securing " + completeURL));
            }
            StringBuilder redirectURL = new StringBuilder();
            redirectURL.append("https://");
            redirectURL.append(request.getServerName());
            redirectURL.append(request.getServletPath());
            String queryString = request.getQueryString();
            if (Validator.isNotNull((String)queryString)) {
                redirectURL.append("?");
                redirectURL.append(request.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect to " + redirectURL));
            }
            response.sendRedirect(redirectURL.toString());
        } else {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Not securing " + completeURL));
            }
            HttpSession session = request.getSession();
            long userId = GetterUtil.getLong((String)((String)session.getAttribute(_AUTHENTICATED_USER)));
            if (this._basicAuthEnabled && !PropsValues.PORTAL_JAAS_ENABLE) {
                if (userId > 0L) {
                    request = new ProtectedServletRequest(request, String.valueOf(userId));
                } else {
                    try {
                        userId = PortalUtil.getBasicAuthUserId((HttpServletRequest)request);
                    }
                    catch (Exception e) {
                        _log.error((Throwable)e);
                    }
                    if (userId > 0L) {
                        String userIdString = String.valueOf(userId);
                        request = new ProtectedServletRequest(request, userIdString);
                        session.setAttribute(_AUTHENTICATED_USER, (Object)userIdString);
                    } else {
                        response.setHeader("WWW-Authenticate", _PORTAL_REALM);
                        response.setStatus(401);
                        return;
                    }
                }
            }
            this.processFilter(SecureFilter.class, request, response, filterChain);
        }
    }
}

