/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.cas;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.filters.DynamicFilterConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;

public class CASFilter
extends BasePortalFilter {
    public static String SCREEN_NAME = CASFilter.class.getName() + "SCREEN_NAME";
    private static Log _log = LogFactoryUtil.getLog(CASFilter.class);
    private static Map<Long, Filter> _casAuthenticationFilters = new ConcurrentHashMap<Long, Filter>();
    private static Map<Long, Filter> _casTicketValidationFilters = new ConcurrentHashMap<Long, Filter>();
    private String _filterName;
    private ServletContext _servletContext;

    public static void reload(long companyId) {
        _casAuthenticationFilters.remove(companyId);
        _casTicketValidationFilters.remove(companyId);
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = this.getFilterConfig().getServletContext();
    }

    protected Filter getCASAuthenticationFilter(long companyId) throws Exception {
        Filter casAuthenticationFilter = _casAuthenticationFilters.get(companyId);
        if (casAuthenticationFilter == null) {
            casAuthenticationFilter = new AuthenticationFilter();
            DynamicFilterConfig dynamicFilterConfig = new DynamicFilterConfig(this._filterName, this._servletContext);
            String serverName = PrefsPropsUtil.getString(companyId, "cas.server.name", PropsValues.CAS_SERVER_NAME);
            String loginUrl = PrefsPropsUtil.getString(companyId, "cas.login.url", PropsValues.CAS_LOGIN_URL);
            dynamicFilterConfig.addInitParameter("serverName", serverName);
            dynamicFilterConfig.addInitParameter("casServerLoginUrl", loginUrl);
            casAuthenticationFilter.init((FilterConfig)dynamicFilterConfig);
            _casAuthenticationFilters.put(companyId, casAuthenticationFilter);
        }
        return casAuthenticationFilter;
    }

    protected Filter getCASTicketValidationFilter(long companyId) throws Exception {
        Filter casTicketValidationFilter = _casTicketValidationFilters.get(companyId);
        if (casTicketValidationFilter == null) {
            casTicketValidationFilter = new Cas20ProxyReceivingTicketValidationFilter();
            DynamicFilterConfig dynamicFilterConfig = new DynamicFilterConfig(this._filterName, this._servletContext);
            String serverName = PrefsPropsUtil.getString(companyId, "cas.server.name", PropsValues.CAS_SERVER_NAME);
            String serverUrl = PrefsPropsUtil.getString(companyId, "cas.server.url", PropsValues.CAS_SERVER_URL);
            String loginUrl = PrefsPropsUtil.getString(companyId, "cas.login.url", PropsValues.CAS_LOGIN_URL);
            dynamicFilterConfig.addInitParameter("serverName", serverName);
            dynamicFilterConfig.addInitParameter("casServerUrlPrefix", serverUrl);
            dynamicFilterConfig.addInitParameter("casServerLoginUrl", loginUrl);
            dynamicFilterConfig.addInitParameter("redirectAfterValidation", "false");
            casTicketValidationFilter.init((FilterConfig)dynamicFilterConfig);
            _casTicketValidationFilters.put(companyId, casTicketValidationFilter);
        }
        return casTicketValidationFilter;
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED)) {
            HttpSession session = request.getSession();
            String pathInfo = request.getPathInfo();
            if (pathInfo.indexOf("/portal/logout") != -1) {
                session.invalidate();
                String logoutUrl = PrefsPropsUtil.getString(companyId, "cas.logout.url", PropsValues.CAS_LOGOUT_URL);
                response.sendRedirect(logoutUrl);
            } else {
                Filter casAuthenticationFilter = this.getCASAuthenticationFilter(companyId);
                casAuthenticationFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
                Filter casTicketValidationFilter = this.getCASTicketValidationFilter(companyId);
                casTicketValidationFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
                Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
                if (assertion != null) {
                    AttributePrincipal attributePrincipal = assertion.getPrincipal();
                    String screenName = attributePrincipal.getName();
                    session.setAttribute(SCREEN_NAME, (Object)screenName);
                }
            }
        } else {
            this.processFilter(CASFilter.class, request, response, filterChain);
        }
    }
}

