/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.ntlm;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.sso.ntlm.NtlmPostFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.filters.DynamicFilterConfig;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.http.NtlmHttpFilter;
import jcifs.http.NtlmSsp;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;

public class NtlmFilter
extends BasePortalFilter {
    private static Log _log = LogFactoryUtil.getLog(NtlmFilter.class);
    private DynamicFilterConfig _filterConfig;

    public void init(FilterConfig filterConfig) {
        try {
            NtlmHttpFilter ntlmFilter = new NtlmHttpFilter();
            ntlmFilter.init(filterConfig);
            Properties properties = PropsUtil.getProperties("jcifs.", false);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Config.setProperty((String)key, (String)value);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._filterConfig = new DynamicFilterConfig(filterConfig);
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long companyId = PortalInstances.getCompanyId(request);
        if (PortalLDAPUtil.isNtlmEnabled(companyId)) {
            byte[] src;
            String authorization;
            String domainController = this._filterConfig.getInitParameter("jcifs.http.domainController");
            String domain = this._filterConfig.getInitParameter("jcifs.smb.client.domain");
            String preferencesDomainController = PrefsPropsUtil.getString(companyId, "ntlm.auth.domain.controller", PropsValues.NTLM_DOMAIN_CONTROLLER);
            String preferencesDomain = PrefsPropsUtil.getString(companyId, "ntlm.auth.domain", PropsValues.NTLM_DOMAIN);
            if (!Validator.equals((Object)domainController, (Object)preferencesDomainController) || !Validator.equals((Object)domain, (Object)preferencesDomain)) {
                domainController = preferencesDomainController;
                domain = preferencesDomain;
                this._filterConfig.addInitParameter("jcifs.http.domainController", domainController);
                this._filterConfig.addInitParameter("jcifs.smb.client.domain", domain);
                super.init((FilterConfig)this._filterConfig);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Host " + domainController));
                _log.debug((Object)("Domain " + domain));
            }
            if ((authorization = GetterUtil.getString((String)request.getHeader("Authorization"))).startsWith("NTLM") && (src = Base64.decode((String)authorization.substring(5)))[8] == 1) {
                UniAddress dc = UniAddress.getByName((String)domainController, (boolean)true);
                byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
                Type1Message type1 = new Type1Message(src);
                Type2Message type2 = new Type2Message(type1, challenge, null);
                authorization = Base64.encode((byte[])type2.toByteArray());
                response.setHeader("WWW-Authenticate", "NTLM " + authorization);
                response.setStatus(401);
                response.setContentLength(0);
                response.flushBuffer();
                return;
            }
            String path = request.getPathInfo();
            if (path != null && path.endsWith("/login")) {
                NtlmPasswordAuthentication ntlm = this.negotiate(request, response, false);
                if (ntlm == null) {
                    return;
                }
                String remoteUser = ntlm.getName();
                int pos = remoteUser.indexOf("\\");
                if (pos != -1) {
                    remoteUser = remoteUser.substring(pos + 1);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("NTLM remote user " + remoteUser));
                }
                request.setAttribute("NTLM_REMOTE_USER", (Object)remoteUser);
            }
        }
        this.processFilter(NtlmPostFilter.class, request, response, filterChain);
    }

    protected NtlmPasswordAuthentication negotiate(HttpServletRequest request, HttpServletResponse response, boolean skipAuthentication) throws Exception {
        NtlmPasswordAuthentication ntlm = null;
        HttpSession session = request.getSession(false);
        String authorization = GetterUtil.getString((String)request.getHeader("Authorization"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Authorization header " + authorization));
        }
        if (authorization.startsWith("NTLM ")) {
            String domainController = this._filterConfig.getInitParameter("jcifs.http.domainController");
            UniAddress uniAddress = UniAddress.getByName((String)domainController, (boolean)true);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Address " + uniAddress));
            }
            byte[] challenge = SmbSession.getChallenge((UniAddress)uniAddress);
            ntlm = NtlmSsp.authenticate((HttpServletRequest)request, (HttpServletResponse)response, (byte[])challenge);
            try {
                SmbSession.logon((UniAddress)uniAddress, (NtlmPasswordAuthentication)ntlm);
            }
            catch (Exception e) {
                response.setHeader("WWW-Authenticate", "NTLM");
                response.setStatus(401);
                response.setContentLength(0);
                response.flushBuffer();
                return null;
            }
            session.setAttribute("NtlmHttpAuth", (Object)ntlm);
        } else {
            if (session != null) {
                ntlm = (NtlmPasswordAuthentication)session.getAttribute("NtlmHttpAuth");
            }
            if (ntlm == null) {
                response.setHeader("WWW-Authenticate", "NTLM");
                response.setStatus(401);
                response.setContentLength(0);
                response.flushBuffer();
                return null;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Password authentication " + ntlm));
        }
        return ntlm;
    }
}

