/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.opensso;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.util.CookieUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSOUtil {
    private static final String _GET_ATTRIBUTES = "/identity/attributes";
    private static final String _GET_COOKIE_NAME = "/identity/getCookieNameForToken";
    private static final String _GET_COOKIE_NAMES = "/identity/getCookieNamesToForward";
    private static final String _VALIDATE_TOKEN = "/identity/isTokenValid";
    private static Log _log = LogFactoryUtil.getLog(OpenSSOUtil.class);
    private static OpenSSOUtil _instance = new OpenSSOUtil();
    private Map<String, String[]> _cookieNamesMap = new ConcurrentHashMap<String, String[]>();

    public static Map<String, String> getAttributes(HttpServletRequest request, String serviceUrl) {
        return _instance._getAttributes(request, serviceUrl);
    }

    public static String getSubjectId(HttpServletRequest request, String serviceUrl) {
        return _instance._getSubjectId(request, serviceUrl);
    }

    public static boolean isAuthenticated(HttpServletRequest request, String serviceUrl) throws IOException {
        return _instance._isAuthenticated(request, serviceUrl);
    }

    private OpenSSOUtil() {
    }

    private Map<String, String> _getAttributes(HttpServletRequest request, String serviceUrl) {
        HashMap<String, String> nameValues;
        block8: {
            nameValues = new HashMap<String, String>();
            String url = serviceUrl + _GET_ATTRIBUTES;
            try {
                URL urlObj = new URL(url);
                HttpURLConnection urlc = (HttpURLConnection)urlObj.openConnection();
                urlc.setDoOutput(true);
                urlc.setRequestMethod("POST");
                urlc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                String[] cookieNames = this._getCookieNames(serviceUrl);
                this._setCookieProperty(request, urlc, cookieNames);
                OutputStreamWriter osw = new OutputStreamWriter(urlc.getOutputStream());
                osw.write("dummy");
                osw.flush();
                int responseCode = urlc.getResponseCode();
                if (responseCode == 200) {
                    UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader((InputStream)urlc.getContent()));
                    String line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (!line.startsWith("userdetails.attribute.name=")) continue;
                        String name = line.replaceFirst("userdetails.attribute.name=", "");
                        line = unsyncBufferedReader.readLine();
                        if (!line.startsWith("userdetails.attribute.value=")) continue;
                        String value = line.replaceFirst("userdetails.attribute.value=", "");
                        nameValues.put(name, value);
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Attributes response code " + responseCode));
                }
            }
            catch (MalformedURLException mfue) {
                _log.error((Object)mfue.getMessage());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)mfue, (Throwable)mfue);
                }
            }
            catch (IOException ioe) {
                _log.error((Object)ioe.getMessage());
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)ioe, (Throwable)ioe);
            }
        }
        return nameValues;
    }

    private String[] _getCookieNames(String serviceUrl) {
        ArrayList<String> cookieNamesList;
        String[] cookieNames;
        block12: {
            cookieNames = this._cookieNamesMap.get(serviceUrl);
            if (cookieNames != null) {
                return cookieNames;
            }
            cookieNamesList = new ArrayList<String>();
            try {
                String line;
                String cookieName = null;
                String url = serviceUrl + _GET_COOKIE_NAME;
                URL urlObj = new URL(url);
                HttpURLConnection urlc = (HttpURLConnection)urlObj.openConnection();
                UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader((InputStream)urlc.getContent()));
                int responseCode = urlc.getResponseCode();
                if (responseCode != 200) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)(url + " has response code " + responseCode));
                    }
                } else {
                    line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (!line.startsWith("string=")) continue;
                        cookieName = line = line.replaceFirst("string=", "");
                    }
                }
                url = serviceUrl + _GET_COOKIE_NAMES;
                urlObj = new URL(url);
                urlc = (HttpURLConnection)urlObj.openConnection();
                unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader((InputStream)urlc.getContent()));
                if (urlc.getResponseCode() != 200) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)(url + " has response code " + responseCode));
                    }
                } else {
                    line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (!line.startsWith("string=")) continue;
                        if (cookieName.equals(line = line.replaceFirst("string=", ""))) {
                            cookieNamesList.add(0, cookieName);
                            continue;
                        }
                        cookieNamesList.add(line);
                    }
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        cookieNames = cookieNamesList.toArray(new String[cookieNamesList.size()]);
        this._cookieNamesMap.put(serviceUrl, cookieNames);
        return cookieNames;
    }

    private String _getSubjectId(HttpServletRequest request, String serviceUrl) {
        String cookieName = this._getCookieNames(serviceUrl)[0];
        return CookieUtil.get((HttpServletRequest)request, (String)cookieName);
    }

    private boolean _isAuthenticated(HttpServletRequest request, String serviceUrl) throws IOException {
        boolean authenticated = false;
        String url = serviceUrl + _VALIDATE_TOKEN;
        URL urlObj = new URL(url);
        HttpURLConnection urlc = (HttpURLConnection)urlObj.openConnection();
        urlc.setDoOutput(true);
        urlc.setRequestMethod("POST");
        urlc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        String[] cookieNames = this._getCookieNames(serviceUrl);
        this._setCookieProperty(request, urlc, cookieNames);
        OutputStreamWriter osw = new OutputStreamWriter(urlc.getOutputStream());
        osw.write("dummy");
        osw.flush();
        int responseCode = urlc.getResponseCode();
        if (responseCode == 200) {
            String data = StringUtil.read((InputStream)urlc.getInputStream());
            if (data.toLowerCase().indexOf("boolean=true") != -1) {
                authenticated = true;
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Authentication response code " + responseCode));
        }
        return authenticated;
    }

    private void _setCookieProperty(HttpServletRequest request, HttpURLConnection urlc, String[] cookieNames) {
        StringBuilder sb = new StringBuilder();
        for (String cookieName : cookieNames) {
            String cookieValue = CookieUtil.get((HttpServletRequest)request, (String)cookieName);
            sb.append(cookieName);
            sb.append("=");
            sb.append(cookieValue);
            sb.append(";");
        }
        if (sb.length() > 0) {
            urlc.setRequestProperty("Cookie", sb.toString());
        }
    }
}

