/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.strip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.KMPSearch;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.portal.servlet.filters.strip.StripResponse;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StripFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = StripFilter.class.getName() + "SKIP_FILTER";
    private static final byte[] _CDATA_CLOSE = "/*]]>*/".getBytes();
    private static final byte[] _CDATA_OPEN = "/*<![CDATA[*/".getBytes();
    private static final double _COMPRESSION_RATE = 0.7;
    private static final byte[] _MARKER_JS_OPEN = "script type=\"text/javascript\">".getBytes();
    private static final byte[] _MARKER_PRE_CLOSE = "/pre>".getBytes();
    private static final int[] _MARKER_PRE_CLOSE_NEXTS = KMPSearch.generateNexts((byte[])_MARKER_PRE_CLOSE);
    private static final byte[] _MARKER_PRE_OPEN = "pre>".getBytes();
    private static final byte[] _MARKER_SCRIPT_CLOSE = "</script>".getBytes();
    private static final int[] _MARKER_SCRIPT_CLOSE_NEXTS = KMPSearch.generateNexts((byte[])_MARKER_SCRIPT_CLOSE);
    private static final byte[] _MARKER_SCRIPT_OPEN = "script>".getBytes();
    private static final byte[] _MARKER_STYLE_CLOSE = "</style>".getBytes();
    private static final int[] _MARKER_STYLE_CLOSE_NEXTS = KMPSearch.generateNexts((byte[])_MARKER_STYLE_CLOSE);
    private static final byte[] _MARKER_STYLE_OPEN = "style type=\"text/css\">".getBytes();
    private static final byte[] _MARKER_TEXTAREA_CLOSE = "/textarea>".getBytes();
    private static final int[] _MARKER_TEXTAREA_CLOSE_NEXTS = KMPSearch.generateNexts((byte[])_MARKER_TEXTAREA_CLOSE);
    private static final byte[] _MARKER_TEXTAREA_OPEN = "textarea ".getBytes();
    private static final byte[] _SCRIPT_TYPE_JAVASCRIPT = "<script type=\"text/javascript\">".getBytes();
    private static final String _STRIP = "strip";
    private static final byte[] _STYLE_TYPE_CSS = "<style type=\"text/css\">".getBytes();
    private static Log _log = LogFactoryUtil.getLog(StripFilter.class);

    protected int countContinuousWhiteSpace(byte[] oldByteArray, int offset) {
        int count = 0;
        for (int i = offset; i < oldByteArray.length; ++i) {
            char c = (char)oldByteArray[i];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                ++count;
                continue;
            }
            return count;
        }
        return count;
    }

    protected boolean hasMarker(byte[] oldByteArray, int pos, byte[] marker) {
        if (pos + marker.length >= oldByteArray.length) {
            return false;
        }
        for (int i = 0; i < marker.length; ++i) {
            byte c = marker[i];
            byte oldC = oldByteArray[pos + i + 1];
            if (c == oldC || Character.toUpperCase(c) == oldC) continue;
            return false;
        }
        return true;
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isInclude(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    protected boolean isStrip(HttpServletRequest request) {
        if (!ParamUtil.getBoolean((HttpServletRequest)request, (String)_STRIP, (boolean)true)) {
            return false;
        }
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle");
        return (!lifecycle.equals("1") || !LiferayWindowState.isExclusive((HttpServletRequest)request)) && !lifecycle.equals("2");
    }

    protected int processCSS(byte[] oldByteArray, UnsyncByteArrayOutputStream newBytes, int currentIndex) {
        int beginIndex = currentIndex + _MARKER_STYLE_OPEN.length + 1;
        int endIndex = KMPSearch.search((byte[])oldByteArray, (int)beginIndex, (byte[])_MARKER_STYLE_CLOSE, (int[])_MARKER_STYLE_CLOSE_NEXTS);
        if (endIndex == -1) {
            _log.error((Object)"Missing </style>");
            return currentIndex + 1;
        }
        int newBeginIndex = endIndex + _MARKER_STYLE_CLOSE.length;
        newBeginIndex += this.countContinuousWhiteSpace(oldByteArray, newBeginIndex);
        String content = new String(oldByteArray, beginIndex, endIndex - beginIndex);
        if (Validator.isNull((String)content)) {
            return newBeginIndex;
        }
        if (Validator.isNull((String)(content = MinifierUtil.minifyCss(content)))) {
            return newBeginIndex;
        }
        newBytes.write(_STYLE_TYPE_CSS);
        newBytes.write(content.getBytes());
        newBytes.write(_MARKER_STYLE_CLOSE);
        return newBeginIndex;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (this.isStrip(request) && !this.isInclude(request) && !this.isAlreadyFiltered(request)) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Stripping " + completeURL));
            }
            request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
            StripResponse stripResponse = new StripResponse(response);
            this.processFilter(StripFilter.class, request, (HttpServletResponse)stripResponse, filterChain);
            String contentType = GetterUtil.getString((String)stripResponse.getContentType()).toLowerCase();
            byte[] oldByteArray = stripResponse.getData();
            if (oldByteArray != null && oldByteArray.length > 0) {
                byte[] newByteArray = null;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Stripping content of type " + contentType));
                }
                if (!ETagUtil.processETag(request, response, newByteArray = contentType.indexOf("text/") != -1 ? this.strip(oldByteArray) : oldByteArray)) {
                    response.setContentType(contentType);
                    ServletResponseUtil.write((HttpServletResponse)response, (byte[])newByteArray);
                }
            }
        } else {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Not stripping " + completeURL));
            }
            this.processFilter(StripFilter.class, request, response, filterChain);
        }
    }

    protected int processJavaScript(byte[] oldByteArray, UnsyncByteArrayOutputStream newBytes, int currentIndex, byte[] openTag) {
        int beginIndex = currentIndex + openTag.length + 1;
        int endIndex = KMPSearch.search((byte[])oldByteArray, (int)beginIndex, (byte[])_MARKER_SCRIPT_CLOSE, (int[])_MARKER_SCRIPT_CLOSE_NEXTS);
        if (endIndex == -1) {
            _log.error((Object)"Missing </script>");
            return currentIndex + 1;
        }
        int newBeginIndex = endIndex + _MARKER_SCRIPT_CLOSE.length;
        newBeginIndex += this.countContinuousWhiteSpace(oldByteArray, newBeginIndex);
        String content = new String(oldByteArray, beginIndex, endIndex - beginIndex);
        if (Validator.isNull((String)content)) {
            return newBeginIndex;
        }
        if (Validator.isNull((String)(content = MinifierUtil.minifyJavaScript(content)))) {
            return newBeginIndex;
        }
        newBytes.write(_SCRIPT_TYPE_JAVASCRIPT);
        newBytes.write(_CDATA_OPEN);
        newBytes.write(content.getBytes());
        newBytes.write(_CDATA_CLOSE);
        newBytes.write(_MARKER_SCRIPT_CLOSE);
        return newBeginIndex;
    }

    protected int processPre(byte[] oldByteArray, UnsyncByteArrayOutputStream newBytes, int currentIndex) {
        int beginIndex = currentIndex + _MARKER_PRE_OPEN.length + 1;
        int endIndex = KMPSearch.search((byte[])oldByteArray, (int)beginIndex, (byte[])_MARKER_PRE_CLOSE, (int[])_MARKER_PRE_CLOSE_NEXTS);
        if (endIndex == -1) {
            _log.error((Object)"Missing </pre>");
            return currentIndex + 1;
        }
        int newBeginIndex = endIndex + _MARKER_PRE_CLOSE.length;
        newBytes.write(oldByteArray, currentIndex, newBeginIndex - currentIndex);
        newBeginIndex += this.countContinuousWhiteSpace(oldByteArray, newBeginIndex);
        return newBeginIndex;
    }

    protected int processTextArea(byte[] oldByteArray, UnsyncByteArrayOutputStream newBytes, int currentIndex) {
        int beginIndex = currentIndex + _MARKER_TEXTAREA_OPEN.length + 1;
        int endIndex = KMPSearch.search((byte[])oldByteArray, (int)beginIndex, (byte[])_MARKER_TEXTAREA_CLOSE, (int[])_MARKER_TEXTAREA_CLOSE_NEXTS);
        if (endIndex == -1) {
            _log.error((Object)"Missing </textArea>");
            return currentIndex + 1;
        }
        int newBeginIndex = endIndex + _MARKER_TEXTAREA_CLOSE.length;
        newBytes.write(oldByteArray, currentIndex, newBeginIndex - currentIndex);
        newBeginIndex += this.countContinuousWhiteSpace(oldByteArray, newBeginIndex);
        return newBeginIndex;
    }

    protected byte[] strip(byte[] oldByteArray) {
        int count;
        UnsyncByteArrayOutputStream newBytes = new UnsyncByteArrayOutputStream((int)((double)oldByteArray.length * 0.7));
        for (int i = count = this.countContinuousWhiteSpace(oldByteArray, 0); i < oldByteArray.length; ++i) {
            int spaceCount;
            byte b = oldByteArray[i];
            if (b == 60) {
                if (this.hasMarker(oldByteArray, i, _MARKER_PRE_OPEN)) {
                    i = this.processPre(oldByteArray, newBytes, i) - 1;
                    continue;
                }
                if (this.hasMarker(oldByteArray, i, _MARKER_TEXTAREA_OPEN)) {
                    i = this.processTextArea(oldByteArray, newBytes, i) - 1;
                    continue;
                }
                if (this.hasMarker(oldByteArray, i, _MARKER_JS_OPEN)) {
                    i = this.processJavaScript(oldByteArray, newBytes, i, _MARKER_JS_OPEN) - 1;
                    continue;
                }
                if (this.hasMarker(oldByteArray, i, _MARKER_SCRIPT_OPEN)) {
                    i = this.processJavaScript(oldByteArray, newBytes, i, _MARKER_SCRIPT_OPEN) - 1;
                    continue;
                }
                if (this.hasMarker(oldByteArray, i, _MARKER_STYLE_OPEN)) {
                    i = this.processCSS(oldByteArray, newBytes, i) - 1;
                    continue;
                }
            } else if (b == 62) {
                newBytes.write((int)b);
                spaceCount = this.countContinuousWhiteSpace(oldByteArray, i + 1);
                if (spaceCount <= 0) continue;
                i += spaceCount;
                newBytes.write(32);
                continue;
            }
            if ((spaceCount = this.countContinuousWhiteSpace(oldByteArray, i)) > 0) {
                newBytes.write(32);
                i = i + spaceCount - 1;
                continue;
            }
            newBytes.write((int)b);
        }
        return newBytes.toByteArray();
    }
}

