/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.strip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.servlet.StringServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class StripResponse
extends HttpServletResponseWrapper {
    private String _contentType;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;

    public StripResponse(HttpServletResponse response) {
        super(response);
    }

    public void finishResponse() {
        try {
            if (this._printWriter != null) {
                this._printWriter.close();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this._servletOutputStream != null) {
            this._servletOutputStream.flush();
        }
    }

    public String getContentType() {
        return this._contentType;
    }

    public byte[] getData() {
        this.finishResponse();
        if (this._unsyncByteArrayOutputStream != null) {
            return this._unsyncByteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public ServletOutputStream getOutputStream() {
        if (this._printWriter != null) {
            throw new IllegalStateException();
        }
        if (this._servletOutputStream == null) {
            this._servletOutputStream = this.createOutputStream();
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._printWriter != null) {
            return this._printWriter;
        }
        if (this._servletOutputStream != null) {
            throw new IllegalStateException();
        }
        this._servletOutputStream = this.createOutputStream();
        this._printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this._servletOutputStream, "UTF-8"));
        return this._printWriter;
    }

    public boolean isCommitted() {
        if (this._servletOutputStream != null) {
            return true;
        }
        return super.isCommitted();
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        super.setContentType(contentType);
    }

    protected ServletOutputStream createOutputStream() {
        this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        return new StringServletOutputStream(this._unsyncByteArrayOutputStream);
    }
}

