/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.taglib.portlet.TagUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionURLTagUtil {
    private static Log _log = LogFactoryUtil.getLog(ActionURLTagUtil.class);

    public static String doEndTag(String lifecycle, String windowState, String portletMode, String var, String varImpl, Boolean secure, Boolean copyCurrentRenderParameters, Boolean escapeXml, String name, String resourceID, String cacheability, long plid, String portletName, Boolean anchor, Boolean encrypt, long doAsUserId, Boolean portletConfiguration, Map<String, String[]> params, boolean writeOutput, PageContext pageContext) throws JspException {
        try {
            LiferayPortletURL portletURL;
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            if (portletName == null) {
                portletName = TagUtil.getPortletName(request);
            }
            if ((portletURL = TagUtil.getLiferayPortletURL(request, plid, portletName, lifecycle)) == null) {
                _log.error((Object)"Render response is null because this tag is not being called within the context of a portlet");
                return "";
            }
            if (Validator.isNotNull((String)windowState)) {
                portletURL.setWindowState(WindowStateFactory.getWindowState((String)windowState));
            }
            if (Validator.isNotNull((String)portletMode)) {
                portletURL.setPortletMode(PortletModeFactory.getPortletMode((String)portletMode));
            }
            if (secure != null) {
                portletURL.setSecure(secure.booleanValue());
            } else {
                portletURL.setSecure(request.isSecure());
            }
            if (copyCurrentRenderParameters != null) {
                portletURL.setCopyCurrentRenderParameters(copyCurrentRenderParameters.booleanValue());
            }
            if (escapeXml != null) {
                portletURL.setEscapeXml(escapeXml.booleanValue());
            }
            if (lifecycle.equals("ACTION_PHASE") && Validator.isNotNull((String)name)) {
                portletURL.setParameter("javax.portlet.action", name);
            }
            if (resourceID != null) {
                portletURL.setResourceID(resourceID);
            }
            if (cacheability != null) {
                portletURL.setCacheability(cacheability);
            }
            if (anchor != null) {
                portletURL.setAnchor(anchor.booleanValue());
            }
            if (encrypt != null) {
                portletURL.setEncrypt(encrypt.booleanValue());
            }
            if (doAsUserId > 0L) {
                portletURL.setDoAsUserId(doAsUserId);
            }
            if (portletConfiguration != null && portletConfiguration.booleanValue()) {
                String returnToFullPageURL = ParamUtil.getString((HttpServletRequest)request, (String)"returnToFullPageURL");
                String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
                String previewWidth = ParamUtil.getString((HttpServletRequest)request, (String)"previewWidth");
                portletURL.setParameter("struts_action", "/portlet_configuration/edit_configuration");
                portletURL.setParameter("returnToFullPageURL", returnToFullPageURL);
                portletURL.setParameter("portletResource", portletResource);
                portletURL.setParameter("previewWidth", previewWidth);
            }
            if (params != null) {
                MapUtil.merge((Map)portletURL.getParameterMap(), params);
                portletURL.setParameters(params);
            }
            if (Validator.isNotNull((String)var)) {
                pageContext.setAttribute(var, (Object)portletURL.toString());
            } else if (Validator.isNotNull((String)varImpl)) {
                pageContext.setAttribute(varImpl, (Object)portletURL);
            } else if (writeOutput) {
                pageContext.getOut().print(portletURL.toString());
            }
            return portletURL.toString();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }
}

