/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.taglib.portlet.ActionURLTagUtil;
import java.util.StringTokenizer;
import javax.portlet.PortletURL;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class RenderURLParamsTagUtil {
    private static Log _log = LogFactoryUtil.getLog(ActionURLTagUtil.class);

    public static String doEndTag(String varImpl, PageContext pageContext) throws JspException {
        try {
            PortletURL portletURL = (PortletURL)pageContext.getAttribute(varImpl);
            String params = "";
            if (portletURL != null) {
                params = RenderURLParamsTagUtil._toParamsString(portletURL);
                pageContext.getOut().print(params);
            }
            return params;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    private static String _toParamsString(PortletURL portletURL) throws Exception {
        StringBuilder sb = new StringBuilder();
        String url = portletURL.toString();
        String queryString = HttpUtil.getQueryString((String)url);
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            String[] kvp;
            String token = st.nextToken();
            if (!Validator.isNotNull((String)token) || (kvp = StringUtil.split((String)token, (String)"=")) == null || kvp.length <= 0) continue;
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            value = HttpUtil.decodeURL((String)value);
            sb.append("<input name=\"");
            sb.append(key);
            sb.append("\" type=\"hidden\" value=\"");
            sb.append(HtmlUtil.escapeAttribute((String)value));
            sb.append("\" />");
        }
        return sb.toString();
    }
}

