/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.security;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.security.Key;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptTagUtil {
    private static Log _log = LogFactoryUtil.getLog(EncryptTagUtil.class);

    public static void doStartTag(String className, String style, String protocol, Set<String> unencryptedParamsSet, String url, String target, PageContext pageContext) throws JspException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<a ");
            if (Validator.isNotNull((String)className)) {
                sb.append("class=\"");
                sb.append(className);
                sb.append("\" ");
            }
            sb.append("href=\"").append(protocol).append("://");
            int pos = url.indexOf("?");
            if (pos == -1) {
                sb.append(url);
            } else {
                sb.append(url.substring(0, pos)).append("?");
                Company company = PortalUtil.getCompany((HttpServletRequest)((HttpServletRequest)pageContext.getRequest()));
                Key key = company.getKeyObj();
                StringTokenizer st = new StringTokenizer(url.substring(pos + 1, url.length()), "&");
                while (st.hasMoreTokens()) {
                    String paramAndValue = st.nextToken();
                    int x = paramAndValue.indexOf("=");
                    String param = paramAndValue.substring(0, x);
                    String value = paramAndValue.substring(x + 1, paramAndValue.length());
                    sb.append(param).append("=");
                    if (unencryptedParamsSet.contains(param)) {
                        sb.append(HttpUtil.encodeURL((String)value));
                        continue;
                    }
                    try {
                        sb.append(HttpUtil.encodeURL((String)Encryptor.encrypt((Key)key, (String)value)));
                    }
                    catch (EncryptorException ee) {
                        _log.error((Object)ee.getMessage());
                    }
                    if (!st.hasMoreTokens()) continue;
                    sb.append("&");
                }
                sb.append("&shuo=1");
            }
            sb.append("\" ");
            if (Validator.isNotNull((String)style)) {
                sb.append("style=\"");
                sb.append(style);
                sb.append("\" ");
            }
            if (Validator.isNotNull((String)target)) {
                sb.append("target=\"" + target + "\"");
            }
            sb.append(">");
            pageContext.getOut().print(sb.toString());
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public static void doEndTag(PageContext pageContext) throws JspException {
        try {
            pageContext.getOut().print("</a>");
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

