/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.ui;

import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.List;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class InputPermissionsParamsTagUtil {
    public static void doEndTag(String modelName, PageContext pageContext) throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            Group group = themeDisplay.getScopeGroup();
            Group layoutGroup = layout.getGroup();
            List<String> supportedActions = ResourceActionsUtil.getModelResourceActions(modelName);
            List<String> communityDefaultActions = ResourceActionsUtil.getModelResourceCommunityDefaultActions(modelName);
            List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(modelName);
            List<String> guestUnsupportedActions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions(modelName);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < supportedActions.size(); ++i) {
                String action = supportedActions.get(i);
                boolean communityChecked = communityDefaultActions.contains(action);
                boolean guestChecked = guestDefaultActions.contains(action);
                boolean guestDisabled = guestUnsupportedActions.contains(action);
                if (guestDisabled) {
                    guestChecked = false;
                }
                if ((group.isCommunity() || group.isOrganization()) && communityChecked) {
                    sb.append("&");
                    sb.append(renderResponse.getNamespace());
                    sb.append("communityPermissions=");
                    sb.append(action);
                }
                if (!guestChecked) continue;
                sb.append("&");
                sb.append(renderResponse.getNamespace());
                sb.append("guestPermissions=");
                sb.append(action);
            }
            boolean inputPermissionsPublic = false;
            if (layoutGroup.getName().equals("Control Panel")) {
                if (!group.hasPrivateLayouts()) {
                    inputPermissionsPublic = true;
                }
            } else if (layout.isPublicLayout()) {
                inputPermissionsPublic = true;
            }
            if (inputPermissionsPublic) {
                sb.append("&");
                sb.append(renderResponse.getNamespace());
                sb.append("inputPermissionsPublic=1");
            }
            pageContext.getOut().print(sb.toString());
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

