/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.ui;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalIncludeUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.util.PropsUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class SocialBookmarkTagUtil {
    private static Log _log = LogFactoryUtil.getLog(SocialBookmarkTagUtil.class);

    public static void doEndTag(String page, String type, String url, String title, String target, PageContext pageContext) throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            request.setAttribute("liferay-ui:social-bookmark:type", (Object)type);
            request.setAttribute("liferay-ui:social-bookmark:url", (Object)url);
            request.setAttribute("liferay-ui:social-bookmark:title", (Object)title);
            request.setAttribute("liferay-ui:social-bookmark:target", (Object)target);
            Object[] socialTypes = PropsUtil.getArray("social.bookmark.types");
            if (!ArrayUtil.contains((Object[])socialTypes, (Object)type)) {
                return;
            }
            String postUrl = SocialBookmarkTagUtil._getPostUrl(type, url, title);
            request.setAttribute("liferay-ui:social-bookmark:postUrl", (Object)postUrl);
            PortalIncludeUtil.include((PageContext)pageContext, (String)page);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    private static String _getPostUrl(String type, String url, String title) throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("liferay:social-bookmark:url", url);
        vars.put("liferay:social-bookmark:title", HttpUtil.encodeURL((String)title));
        String postUrl = PropsUtil.get("social.bookmark.post.url", new Filter(type, vars));
        return postUrl;
    }
}

