/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.taglib.ui;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.SessionClicks;
import com.liferay.util.PwdGenerator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class ToggleTagUtil {
    private static Log _log = LogFactoryUtil.getLog(ToggleTagUtil.class);

    public static void doEndTag(String page, String id, String showImage, String hideImage, String showMessage, String hideMessage, boolean defaultShowContent, String stateVar, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws JspException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            if (Validator.isNull((String)showImage) && Validator.isNull((String)showMessage)) {
                showImage = themeDisplay.getPathThemeImages() + "/arrows/01_down.png";
            }
            if (Validator.isNull((String)hideImage) && Validator.isNull((String)hideImage)) {
                hideImage = themeDisplay.getPathThemeImages() + "/arrows/01_right.png";
            }
            String defaultStateValue = defaultShowContent ? "" : "none";
            String defaultImage = defaultShowContent ? hideImage : showImage;
            String defaultMessage = defaultShowContent ? hideMessage : showMessage;
            String clickValue = SessionClicks.get(request, id, null);
            if (defaultShowContent) {
                if (clickValue != null && clickValue.equals("none")) {
                    defaultStateValue = "none";
                    defaultImage = showImage;
                    defaultMessage = showMessage;
                } else {
                    defaultStateValue = "";
                    defaultImage = hideImage;
                    defaultMessage = hideMessage;
                }
            } else if (clickValue == null || clickValue.equals("none")) {
                defaultStateValue = "none";
                defaultImage = showImage;
                defaultMessage = showMessage;
            } else {
                defaultStateValue = "";
                defaultImage = hideImage;
                defaultMessage = hideMessage;
            }
            if (stateVar == null) {
                stateVar = PwdGenerator.getPassword((String)PwdGenerator.KEY3, (int)8);
            }
            request.setAttribute("liferay-ui:toggle:id", (Object)id);
            request.setAttribute("liferay-ui:toggle:showImage", (Object)showImage);
            request.setAttribute("liferay-ui:toggle:hideImage", (Object)hideImage);
            request.setAttribute("liferay-ui:toggle:showMessage", (Object)showMessage);
            request.setAttribute("liferay-ui:toggle:hideMessage", (Object)hideMessage);
            request.setAttribute("liferay-ui:toggle:stateVar", (Object)stateVar);
            request.setAttribute("liferay-ui:toggle:defaultStateValue", (Object)defaultStateValue);
            request.setAttribute("liferay-ui:toggle:defaultImage", (Object)defaultImage);
            request.setAttribute("liferay-ui:toggle:defaultMessage", (Object)defaultMessage);
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(page);
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }
}

