/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.sharepoint.BaseSharepointStorageImpl;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.Tree;
import java.util.LinkedHashMap;
import java.util.List;

public class CompanySharepointStorageImpl
extends BaseSharepointStorageImpl {
    public Tree getFoldersTree(SharepointRequest sharepointRequest) throws Exception {
        Tree foldersTree = new Tree();
        LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
        groupParams.put("usersGroups", new Long(sharepointRequest.getUserId()));
        List groups = GroupLocalServiceUtil.search((long)sharepointRequest.getCompanyId(), null, null, groupParams, (int)-1, (int)-1);
        Group userGroup = GroupLocalServiceUtil.getUserGroup((long)sharepointRequest.getCompanyId(), (long)sharepointRequest.getUserId());
        groups.add(userGroup);
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)sharepointRequest.getUserId(), (boolean)true);
        for (Organization organization : organizations) {
            groups.add(organization.getGroup());
        }
        for (Group group : groups) {
            String path = this.getGroupPath(group);
            foldersTree.addChild(this.getFolderTree(path));
        }
        foldersTree.addChild(this.getFolderTree(""));
        return foldersTree;
    }

    protected String getGroupPath(Group group) throws Exception {
        StringBuilder sb = new StringBuilder();
        String name = group.getName();
        long classPK = group.getClassPK();
        if (group.isUser()) {
            User user = UserServiceUtil.getUserById((long)classPK);
            name = user.getFullName();
        } else if (group.isOrganization()) {
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)classPK);
            name = organization.getName();
        }
        sb.append(name);
        sb.append(" ");
        sb.append("[");
        sb.append(group.getGroupId());
        sb.append("]");
        return sb.toString();
    }
}

