/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SharepointFilter
extends BasePortalFilter {
    private static final String[] _PREFIXES = new String[]{"/_vti_inf.html", "/_vti_bin", "/sharepoint", "/history", "/resources"};
    private static Log _log = LogFactoryUtil.getLog(SharepointFilter.class);

    protected boolean isSharepointRequest(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.endsWith("*.asmx")) {
            return true;
        }
        for (String prefix : _PREFIXES) {
            if (!uri.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected User login(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int pos;
        User user = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return user;
        }
        StringTokenizer st = new StringTokenizer(authorization);
        if (!st.hasMoreTokens()) {
            return user;
        }
        String basic = st.nextToken();
        if (!basic.equalsIgnoreCase("BASIC")) {
            return user;
        }
        String encodedCredentials = st.nextToken();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Encoded credentials are " + encodedCredentials));
        }
        String decodedCredentials = new String(Base64.decode((String)encodedCredentials));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Decoded credentials are " + decodedCredentials));
        }
        if ((pos = decodedCredentials.indexOf(":")) == -1) {
            return user;
        }
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        String login = GetterUtil.getString((String)decodedCredentials.substring(0, pos));
        long userId = GetterUtil.getLong((String)login);
        String password = decodedCredentials.substring(pos + 1);
        HashMap headerMap = new HashMap();
        HashMap parameterMap = new HashMap();
        int authResult = -1;
        if (company.getAuthType().equals("emailAddress")) {
            authResult = UserLocalServiceUtil.authenticateByEmailAddress((long)company.getCompanyId(), (String)login, (String)password, headerMap, parameterMap);
            userId = UserLocalServiceUtil.getUserIdByEmailAddress((long)company.getCompanyId(), (String)login);
        } else if (company.getAuthType().equals("screenName")) {
            authResult = UserLocalServiceUtil.authenticateByScreenName((long)company.getCompanyId(), (String)login, (String)password, headerMap, parameterMap);
            userId = UserLocalServiceUtil.getUserIdByScreenName((long)company.getCompanyId(), (String)login);
        } else if (company.getAuthType().equals("userId")) {
            authResult = UserLocalServiceUtil.authenticateByUserId((long)company.getCompanyId(), (long)userId, (String)password, headerMap, parameterMap);
        }
        if (authResult == 1) {
            user = UserLocalServiceUtil.getUser((long)userId);
        }
        return user;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String method = request.getMethod();
        String userAgent = GetterUtil.getString((String)request.getHeader("User-Agent"));
        if ((userAgent.startsWith("Microsoft Data Access Internet Publishing") || userAgent.startsWith("Microsoft Office Protocol Discovery")) && method.equals("OPTIONS")) {
            this.setOptionsHeaders(response);
            return;
        }
        if (!this.isSharepointRequest(request.getRequestURI())) {
            this.processFilter(SharepointFilter.class, request, response, filterChain);
            return;
        }
        if (method.equals("GET") || method.equals("HEAD")) {
            this.setGetHeaders(response);
        } else if (method.equals("POST")) {
            this.setPostHeaders(response);
        }
        HttpSession session = request.getSession();
        User user = (User)session.getAttribute("USER");
        try {
            if (user == null) {
                user = this.login(request, response);
                if (user == null) {
                    throw new PrincipalException("User is null");
                }
                session.setAttribute("USER", (Object)user);
            }
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)false);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception e) {
            this.sendUnauthorized(response);
            return;
        }
        try {
            this.processFilter(SharepointFilter.class, request, response, filterChain);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void sendUnauthorized(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "BASIC realm=\"Liferay\"");
        response.setStatus(401);
        response.flushBuffer();
    }

    protected void setGetHeaders(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setHeader("Public-Extension", "http://schemas.microsoft.com/repl-2");
        response.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        response.setHeader("Cache-Control", "no-cache");
    }

    protected void setOptionsHeaders(HttpServletResponse response) {
        response.setHeader("MS-Author-Via", "MS-FP/4.0,DAV");
        response.setHeader("MicrosoftOfficeWebServer", "5.0_Collab");
        response.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        response.setHeader("DAV", "1,2");
        response.setHeader("Accept-Ranges", "none");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Allow", "COPY, DELETE, GET, GETLIB, HEAD, LOCK, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, UNLOCK");
    }

    protected void setPostHeaders(HttpServletResponse response) {
        response.setContentType("application/x-vermeer-rpc");
        response.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "close");
    }
}

