/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.methods.Method;
import com.liferay.portal.sharepoint.methods.MethodFactory;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(SharepointServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String uri = request.getRequestURI();
            if (uri.equals("/_vti_inf.html")) {
                this.vtiInfHtml(response);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String uri = request.getRequestURI();
            if (uri.equals("/_vti_bin/shtml.dll/_vti_rpc") || uri.equals("/sharepoint/_vti_bin/_vti_aut/author.dll")) {
                User user = (User)request.getSession().getAttribute("USER");
                SharepointRequest sharepointRequest = new SharepointRequest(request, response, user);
                this.addParams(request, sharepointRequest);
                Method method = MethodFactory.create(sharepointRequest);
                String rootPath = method.getRootPath(sharepointRequest);
                sharepointRequest.setRootPath(rootPath);
                SharepointStorage storage = SharepointUtil.getStorage(rootPath);
                sharepointRequest.setSharepointStorage(storage);
                method.process(sharepointRequest);
            }
        }
        catch (SharepointException se) {
            _log.error((Object)se, (Throwable)((Object)se));
        }
    }

    protected void addParams(HttpServletRequest request, SharepointRequest sharepointRequest) throws SharepointException {
        String contentType = request.getContentType();
        if (!contentType.equals("application/x-vermeer-urlencoded")) {
            return;
        }
        try {
            String[] params;
            ServletInputStream is = request.getInputStream();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader((InputStream)is));
            String url = unsyncBufferedReader.readLine();
            for (String param : params = url.split("&")) {
                String[] kvp = param.split("=");
                String key = HttpUtil.decodeURL((String)kvp[0]);
                String value = "";
                if (kvp.length > 1) {
                    value = HttpUtil.decodeURL((String)kvp[1]);
                }
                sharepointRequest.addParam(key, value);
            }
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            StreamUtil.transfer((InputStream)is, (OutputStream)unsyncByteArrayOutputStream);
            sharepointRequest.setBytes(unsyncByteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            throw new SharepointException(e);
        }
    }

    protected void vtiInfHtml(HttpServletResponse response) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- FrontPage Configuration Information");
        sb.append("\n");
        sb.append(" FPVersion=\"6.0.2.9999\"");
        sb.append("\n");
        sb.append("FPShtmlScriptUrl=\"_vti_bin/shtml.dll/_vti_rpc\"");
        sb.append("\n");
        sb.append("FPAuthorScriptUrl=\"_vti_bin/_vti_aut/author.dll\"");
        sb.append("\n");
        sb.append("FPAdminScriptUrl=\"_vti_bin/_vti_adm/admin.dll\"");
        sb.append("\n");
        sb.append("TPScriptUrl=\"_vti_bin/owssvr.dll\"");
        sb.append("\n");
        sb.append("-->");
        ServletResponseUtil.write((HttpServletResponse)response, (String)sb.toString());
    }
}

