/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.sharepoint.CompanySharepointStorageImpl;
import com.liferay.portal.sharepoint.GroupSharepointStorageImpl;
import com.liferay.portal.sharepoint.Property;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.util.PropsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharepointUtil {
    public static final String VEERMER_URLENCODED = "application/x-vermeer-urlencoded";
    public static final String VERSION = "6.0.2.8117";
    private static SharepointUtil _instance = new SharepointUtil();
    private final Map<String, String> _storageMap = new HashMap<String, String>();

    public static void addBottom(StringBuilder sb) {
        sb.append("</body>");
        sb.append("\n");
        sb.append("</html>");
    }

    public static void addTop(StringBuilder sb, String methodName) {
        sb.append("<html><head><title>vermeer RPC packet</title></head>");
        sb.append("\n");
        sb.append("<body>");
        sb.append("\n");
        Property method = new Property("method", methodName + ":" + VERSION);
        sb.append(method.parse());
    }

    public static long getGroupId(String path) {
        int pos;
        long groupId = 0L;
        String[] pathArray = SharepointUtil.getPathArray(path);
        String groupFolderName = pathArray[0];
        if (groupFolderName != null && (pos = groupFolderName.lastIndexOf("[")) != -1) {
            groupId = GetterUtil.getLong((String)groupFolderName.substring(pos, groupFolderName.length() - 1));
        }
        return groupId;
    }

    public static String[] getPathArray(String path) {
        return StringUtil.split((String)path, (String)"/");
    }

    public static SharepointStorage getStorage(String path) {
        String storageClass = null;
        if (path == null) {
            return null;
        }
        String[] pathArray = SharepointUtil.getPathArray(path);
        if (pathArray.length == 0) {
            storageClass = CompanySharepointStorageImpl.class.getName();
        } else if (pathArray.length == 1) {
            storageClass = GroupSharepointStorageImpl.class.getName();
        } else if (pathArray.length >= 2) {
            storageClass = SharepointUtil.getStorageClass(pathArray[1]);
        }
        return (SharepointStorage)InstancePool.get((String)storageClass);
    }

    public static String getStorageClass(String token) {
        return _instance._getStorageClass(token);
    }

    public static String getStorageToken(String className) {
        return _instance._getStorageToken(className);
    }

    public static Collection<String> getStorageTokens() {
        return _instance._getStorageTokens();
    }

    public static String replaceBackSlashes(String value) {
        return value.replaceAll("\\\\", "");
    }

    private SharepointUtil() {
        String[] tokens;
        for (String token : tokens = PropsUtil.getArray("sharepoint.storage.tokens")) {
            Filter filter = new Filter(token);
            String className = PropsUtil.get("sharepoint.storage.class", filter);
            if (!Validator.isNotNull((String)className)) continue;
            this._storageMap.put(className, token);
        }
    }

    private String _getStorageClass(String token) {
        if (this._storageMap.containsValue(token)) {
            for (String key : this._storageMap.keySet()) {
                if (!this._storageMap.get(key).equals(token)) continue;
                return key;
            }
        }
        return null;
    }

    private String _getStorageToken(String className) {
        return this._storageMap.get(className);
    }

    private Collection<String> _getStorageTokens() {
        return this._storageMap.values();
    }
}

