/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.annotation;

import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReferenceAnnotationBeanPostProcessor
implements BeanFactoryAware,
BeanPostProcessor {
    private static String _JAVA_LANG_OBJECT = "java.lang.Object";
    private static String _ORG_SPRINGFRAMEWORK = "org.springframework";
    private BeanFactory _beanFactory;
    private Map<String, Object> _beans = new HashMap<String, Object>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this._autoInject(bean, beanName, bean.getClass());
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this._beanFactory = beanFactory;
    }

    private void _autoInject(Object targetBean, String targetBeanName, Class<?> beanClass) {
        Field[] fields;
        if (beanClass == null || beanClass.isInterface()) {
            return;
        }
        String className = beanClass.getName();
        if (className.equals(_JAVA_LANG_OBJECT) || className.startsWith(_ORG_SPRINGFRAMEWORK)) {
            return;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            BeanReference beanReference = field.getAnnotation(BeanReference.class);
            if (beanReference == null) continue;
            String referencedBeanName = beanReference.name();
            Object referencedBean = this._beans.get(referencedBeanName);
            if (referencedBean == null) {
                try {
                    referencedBean = this._beanFactory.getBean(referencedBeanName);
                }
                catch (NoSuchBeanDefinitionException nsbde) {
                    referencedBean = PortalBeanLocatorUtil.locate((String)referencedBeanName);
                }
                this._beans.put(referencedBeanName, referencedBean);
            }
            ReflectionUtils.makeAccessible((Field)field);
            try {
                field.set(targetBean, referencedBean);
            }
            catch (Throwable t) {
                throw new BeanCreationException(targetBeanName, "Could not inject BeanReference fields", t);
            }
        }
        this._autoInject(targetBean, targetBeanName, beanClass.getSuperclass());
    }
}

