/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.annotation;

import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class PortalTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement annotatedElement) {
        Transactional annotation = annotatedElement.getAnnotation(Transactional.class);
        if (annotation == null) {
            return null;
        }
        RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
        int isolationLevel = annotation.isolation().value();
        if (isolationLevel == -2) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_PORTAL);
        } else {
            ruleBasedTransactionAttribute.setIsolationLevel(isolationLevel);
        }
        ruleBasedTransactionAttribute.setPropagationBehavior(annotation.propagation().value());
        ruleBasedTransactionAttribute.setReadOnly(annotation.readOnly());
        ruleBasedTransactionAttribute.setTimeout(annotation.timeout());
        ArrayList<Object> rollBackAttributes = new ArrayList<Object>();
        Class[] rollbackFor = annotation.rollbackFor();
        for (int i = 0; i < rollbackFor.length; ++i) {
            RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(rollbackFor[i]);
            rollBackAttributes.add(rollbackRuleAttribute);
        }
        String[] rollbackForClassName = annotation.rollbackForClassName();
        for (int i = 0; i < rollbackForClassName.length; ++i) {
            RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(rollbackForClassName[i]);
            rollBackAttributes.add(rollbackRuleAttribute);
        }
        Class[] noRollbackFor = annotation.noRollbackFor();
        for (int i = 0; i < noRollbackFor.length; ++i) {
            NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackFor[i]);
            rollBackAttributes.add(noRollbackRuleAttribute);
        }
        String[] noRollbackForClassName = annotation.noRollbackForClassName();
        for (int i = 0; i < noRollbackForClassName.length; ++i) {
            NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackForClassName[i]);
            rollBackAttributes.add(noRollbackRuleAttribute);
        }
        ruleBasedTransactionAttribute.getRollbackRules().addAll(rollBackAttributes);
        return ruleBasedTransactionAttribute;
    }
}

