/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.BaseModelExtension;
import com.liferay.portal.spring.aop.AbstractModelExtensionHandler;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseModelExtensionHandler<T>
extends AbstractModelExtensionHandler<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseModelExtensionHandler.class);

    public Object extendSingle(BaseModel<T> model) {
        if (model instanceof BaseModelExtension) {
            return model;
        }
        BaseModelExtension extension = this.getBaseModelExtension().extend(model);
        if (_log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Extending ");
            sb.append(model.getClass().getName());
            sb.append(" to ");
            sb.append(extension.getClass().getName());
            _log.debug((Object)sb.toString());
        }
        return extension;
    }

    @Override
    public Object extendList(List<BaseModel<T>> models) {
        return new AbstractModelExtensionHandler.WrappedList(models);
    }
}

