/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class BeanInterceptor
implements MethodInterceptor {
    private ClassLoader _classLoader;
    private boolean _exceptionSafe;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable t) {
            if (this._exceptionSafe) {
                Object var5_6 = null;
                return var5_6;
            }
            throw t;
        }
        finally {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setExceptionSafe(boolean exceptionSafe) {
        this._exceptionSafe = exceptionSafe;
    }
}

