/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;

public class LogAdvice {
    private static Map<String, Log> _logs = new HashMap<String, Log>();

    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String typeName = proceedingJoinPoint.getTarget().getClass().getName();
        Log log = this.getLog(typeName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Before " + typeName));
        }
        Object returnVal = proceedingJoinPoint.proceed();
        if (log.isInfoEnabled()) {
            log.info((Object)("After " + typeName));
        }
        return returnVal;
    }

    protected Log getLog(String typeName) {
        Log log = _logs.get(typeName);
        if (log == null) {
            log = LogFactoryUtil.getLog((String)typeName);
            _logs.put(typeName, log);
        }
        return log;
    }
}

